/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvIcmpId;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvIcmpIdVer15
implements OFBsnTlvIcmpId {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvIcmpIdVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 6;
    private static final int DEFAULT_VALUE = 0;
    private final int value;
    static final OFBsnTlvIcmpIdVer15 DEFAULT = new OFBsnTlvIcmpIdVer15(0);
    static final Reader READER = new Reader();
    static final OFBsnTlvIcmpIdVer15Funnel FUNNEL = new OFBsnTlvIcmpIdVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvIcmpIdVer15(int value) {
        this.value = U16.normalize(value);
    }

    @Override
    public int getType() {
        return 70;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBsnTlvIcmpId.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvIcmpIdVer15(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvIcmpIdVer15 other = (OFBsnTlvIcmpIdVer15)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.value;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvIcmpIdVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvIcmpIdVer15 message) {
            bb.writeShort(70);
            bb.writeShort(6);
            bb.writeShort((int)U16.t(message.value));
        }
    }

    static class OFBsnTlvIcmpIdVer15Funnel
    implements Funnel<OFBsnTlvIcmpIdVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvIcmpIdVer15Funnel() {
        }

        public void funnel(OFBsnTlvIcmpIdVer15 message, PrimitiveSink sink) {
            sink.putShort((short)70);
            sink.putShort((short)6);
            sink.putInt(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvIcmpId> {
        Reader() {
        }

        @Override
        public OFBsnTlvIcmpId readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 70) {
                throw new OFParseError("Wrong type: Expected=0x46(0x46), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 6) {
                throw new OFParseError("Wrong length: Expected=6(6), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            int value = U16.f(bb.readShort());
            OFBsnTlvIcmpIdVer15 bsnTlvIcmpIdVer15 = new OFBsnTlvIcmpIdVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvIcmpIdVer15);
            }
            return bsnTlvIcmpIdVer15;
        }
    }

    static class Builder
    implements OFBsnTlvIcmpId.Builder {
        private boolean valueSet;
        private int value;

        Builder() {
        }

        @Override
        public int getType() {
            return 70;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvIcmpId.Builder setValue(int value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvIcmpId build() {
            int value = this.valueSet ? this.value : 0;
            return new OFBsnTlvIcmpIdVer15(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvIcmpId.Builder {
        final OFBsnTlvIcmpIdVer15 parentMessage;
        private boolean valueSet;
        private int value;

        BuilderWithParent(OFBsnTlvIcmpIdVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 70;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvIcmpId.Builder setValue(int value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvIcmpId build() {
            int value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvIcmpIdVer15(value);
        }
    }
}

