/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnAdminState;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvAdminState;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnAdminStateSerializerVer15;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvAdminStateVer15
implements OFBsnTlvAdminState {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvAdminStateVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 5;
    private final OFBsnAdminState value;
    static final Reader READER = new Reader();
    static final OFBsnTlvAdminStateVer15Funnel FUNNEL = new OFBsnTlvAdminStateVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvAdminStateVer15(OFBsnAdminState value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvAdminStateVer15: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 216;
    }

    @Override
    public OFBsnAdminState getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBsnTlvAdminState.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvAdminStateVer15(");
        b.append("value=").append((Object)this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvAdminStateVer15 other = (OFBsnTlvAdminStateVer15)obj;
        return !(this.value == null ? other.value != null : !this.value.equals((Object)other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvAdminStateVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvAdminStateVer15 message) {
            bb.writeShort(216);
            bb.writeShort(5);
            OFBsnAdminStateSerializerVer15.writeTo(bb, message.value);
        }
    }

    static class OFBsnTlvAdminStateVer15Funnel
    implements Funnel<OFBsnTlvAdminStateVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvAdminStateVer15Funnel() {
        }

        public void funnel(OFBsnTlvAdminStateVer15 message, PrimitiveSink sink) {
            sink.putShort((short)216);
            sink.putShort((short)5);
            OFBsnAdminStateSerializerVer15.putTo(message.value, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvAdminState> {
        Reader() {
        }

        @Override
        public OFBsnTlvAdminState readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 216) {
                throw new OFParseError("Wrong type: Expected=0xd8(0xd8), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 5) {
                throw new OFParseError("Wrong length: Expected=5(5), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFBsnAdminState value = OFBsnAdminStateSerializerVer15.readFrom(bb);
            OFBsnTlvAdminStateVer15 bsnTlvAdminStateVer15 = new OFBsnTlvAdminStateVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvAdminStateVer15);
            }
            return bsnTlvAdminStateVer15;
        }
    }

    static class Builder
    implements OFBsnTlvAdminState.Builder {
        private boolean valueSet;
        private OFBsnAdminState value;

        Builder() {
        }

        @Override
        public int getType() {
            return 216;
        }

        @Override
        public OFBsnAdminState getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvAdminState.Builder setValue(OFBsnAdminState value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvAdminState build() {
            if (!this.valueSet) {
                throw new IllegalStateException("Property value doesn't have default value -- must be set");
            }
            if (this.value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvAdminStateVer15(this.value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvAdminState.Builder {
        final OFBsnTlvAdminStateVer15 parentMessage;
        private boolean valueSet;
        private OFBsnAdminState value;

        BuilderWithParent(OFBsnTlvAdminStateVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 216;
        }

        @Override
        public OFBsnAdminState getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvAdminState.Builder setValue(OFBsnAdminState value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvAdminState build() {
            OFBsnAdminState value;
            OFBsnAdminState oFBsnAdminState = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvAdminStateVer15(value);
        }
    }
}

