/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnPacketField;

public class OFBsnPacketFieldSerializerVer15 {
    public static final short BSN_PACKET_FIELD_UNKNOWN_VAL = 0;
    public static final short BSN_PACKET_FIELD_OUTER_VLAN_TAG_1_VAL = 1;
    public static final short BSN_PACKET_FIELD_OUTER_VLAN_TAG_2_VAL = 2;
    public static final short BSN_PACKET_FIELD_SRC_MAC_VAL = 3;

    public static OFBsnPacketField readFrom(ByteBuf bb) throws OFParseError {
        try {
            return OFBsnPacketFieldSerializerVer15.ofWireValue(bb.readShort());
        }
        catch (IllegalArgumentException e) {
            throw new OFParseError(e);
        }
    }

    public static void writeTo(ByteBuf bb, OFBsnPacketField e) {
        bb.writeShort((int)OFBsnPacketFieldSerializerVer15.toWireValue(e));
    }

    public static void putTo(OFBsnPacketField e, PrimitiveSink sink) {
        sink.putShort(OFBsnPacketFieldSerializerVer15.toWireValue(e));
    }

    public static OFBsnPacketField ofWireValue(short val) {
        switch (val) {
            case 0: {
                return OFBsnPacketField.BSN_PACKET_FIELD_UNKNOWN;
            }
            case 1: {
                return OFBsnPacketField.BSN_PACKET_FIELD_OUTER_VLAN_TAG_1;
            }
            case 2: {
                return OFBsnPacketField.BSN_PACKET_FIELD_OUTER_VLAN_TAG_2;
            }
            case 3: {
                return OFBsnPacketField.BSN_PACKET_FIELD_SRC_MAC;
            }
        }
        throw new IllegalArgumentException("Illegal wire value for type OFBsnPacketField in version 1.5: " + val);
    }

    public static short toWireValue(OFBsnPacketField e) {
        switch (e) {
            case BSN_PACKET_FIELD_UNKNOWN: {
                return 0;
            }
            case BSN_PACKET_FIELD_OUTER_VLAN_TAG_1: {
                return 1;
            }
            case BSN_PACKET_FIELD_OUTER_VLAN_TAG_2: {
                return 2;
            }
            case BSN_PACKET_FIELD_SRC_MAC: {
                return 3;
            }
        }
        throw new IllegalArgumentException("Illegal enum value for type OFBsnPacketField in version 1.5: " + (Object)((Object)e));
    }
}

