/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnHeader;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnArpIdleVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnBwClearDataReplyVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnBwClearDataRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnBwEnableGetReplyVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnBwEnableGetRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnBwEnableSetReplyVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnBwEnableSetRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnControllerConnectionsReplyVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnControllerConnectionsRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnFlowIdleEnableGetReplyVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnFlowIdleEnableGetRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnFlowIdleEnableSetReplyVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnFlowIdleEnableSetRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnFlowIdleVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnGenericAsyncVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnGenericCommandReplyVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnGenericCommandVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnGentableClearReplyVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnGentableClearRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnGentableEntryAddVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnGentableEntryDeleteVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnGentableSetBucketsSizeVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnGetInterfacesReplyVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnGetInterfacesRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnGetMirroringReplyVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnGetMirroringRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnGetSwitchPipelineReplyVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnGetSwitchPipelineRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnLacpConvergenceNotifVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnLogVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnLuaCommandReplyVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnLuaCommandRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnLuaNotificationVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnLuaUploadVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnPduRxReplyVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnPduRxRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnPduRxTimeoutVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnPduTxReplyVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnPduTxRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnSetAuxCxnsReplyVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnSetAuxCxnsRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnSetLacpReplyVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnSetLacpRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnSetMirroringVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnSetPktinSuppressionReplyVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnSetPktinSuppressionRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnSetSwitchPipelineReplyVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnSetSwitchPipelineRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnTableSetBucketsSizeVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnTakeoverVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnTimeReplyVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnTimeRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnVirtualPortCreateReplyVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnVirtualPortCreateRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnVirtualPortRemoveReplyVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnVirtualPortRemoveRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnVlanCounterClearVer15;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;

abstract class OFBsnHeaderVer15 {
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 16;
    public static final Reader READER = new Reader();

    OFBsnHeaderVer15() {
    }

    static class Reader
    implements OFMessageReader<OFBsnHeader> {
        Reader() {
        }

        @Override
        public OFBsnHeader readFrom(ByteBuf bb) throws OFParseError {
            if (bb.readableBytes() < 16) {
                return null;
            }
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 6) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_15(6), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 16) {
                throw new OFParseError("Wrong length: Expected to be >= 16, was: " + length);
            }
            U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            bb.readerIndex(start);
            switch (subtype) {
                case 22: {
                    return OFBsnBwClearDataReplyVer15.READER.readFrom(bb);
                }
                case 21: {
                    return OFBsnBwClearDataRequestVer15.READER.readFrom(bb);
                }
                case 20: {
                    return OFBsnBwEnableGetReplyVer15.READER.readFrom(bb);
                }
                case 19: {
                    return OFBsnBwEnableGetRequestVer15.READER.readFrom(bb);
                }
                case 23: {
                    return OFBsnBwEnableSetReplyVer15.READER.readFrom(bb);
                }
                case 18: {
                    return OFBsnBwEnableSetRequestVer15.READER.readFrom(bb);
                }
                case 10: {
                    return OFBsnGetInterfacesReplyVer15.READER.readFrom(bb);
                }
                case 9: {
                    return OFBsnGetInterfacesRequestVer15.READER.readFrom(bb);
                }
                case 5: {
                    return OFBsnGetMirroringReplyVer15.READER.readFrom(bb);
                }
                case 4: {
                    return OFBsnGetMirroringRequestVer15.READER.readFrom(bb);
                }
                case 34: {
                    return OFBsnPduRxReplyVer15.READER.readFrom(bb);
                }
                case 33: {
                    return OFBsnPduRxRequestVer15.READER.readFrom(bb);
                }
                case 35: {
                    return OFBsnPduRxTimeoutVer15.READER.readFrom(bb);
                }
                case 32: {
                    return OFBsnPduTxReplyVer15.READER.readFrom(bb);
                }
                case 31: {
                    return OFBsnPduTxRequestVer15.READER.readFrom(bb);
                }
                case 3: {
                    return OFBsnSetMirroringVer15.READER.readFrom(bb);
                }
                case 25: {
                    return OFBsnSetPktinSuppressionReplyVer15.READER.readFrom(bb);
                }
                case 11: {
                    return OFBsnSetPktinSuppressionRequestVer15.READER.readFrom(bb);
                }
                case 16: {
                    return OFBsnVirtualPortCreateReplyVer15.READER.readFrom(bb);
                }
                case 15: {
                    return OFBsnVirtualPortCreateRequestVer15.READER.readFrom(bb);
                }
                case 26: {
                    return OFBsnVirtualPortRemoveReplyVer15.READER.readFrom(bb);
                }
                case 17: {
                    return OFBsnVirtualPortRemoveRequestVer15.READER.readFrom(bb);
                }
                case 60: {
                    return OFBsnArpIdleVer15.READER.readFrom(bb);
                }
                case 57: {
                    return OFBsnControllerConnectionsReplyVer15.READER.readFrom(bb);
                }
                case 56: {
                    return OFBsnControllerConnectionsRequestVer15.READER.readFrom(bb);
                }
                case 40: {
                    return OFBsnFlowIdleVer15.READER.readFrom(bb);
                }
                case 39: {
                    return OFBsnFlowIdleEnableGetReplyVer15.READER.readFrom(bb);
                }
                case 38: {
                    return OFBsnFlowIdleEnableGetRequestVer15.READER.readFrom(bb);
                }
                case 37: {
                    return OFBsnFlowIdleEnableSetReplyVer15.READER.readFrom(bb);
                }
                case 36: {
                    return OFBsnFlowIdleEnableSetRequestVer15.READER.readFrom(bb);
                }
                case 49: {
                    return OFBsnGentableClearReplyVer15.READER.readFrom(bb);
                }
                case 48: {
                    return OFBsnGentableClearRequestVer15.READER.readFrom(bb);
                }
                case 46: {
                    return OFBsnGentableEntryAddVer15.READER.readFrom(bb);
                }
                case 47: {
                    return OFBsnGentableEntryDeleteVer15.READER.readFrom(bb);
                }
                case 50: {
                    return OFBsnGentableSetBucketsSizeVer15.READER.readFrom(bb);
                }
                case 52: {
                    return OFBsnGetSwitchPipelineReplyVer15.READER.readFrom(bb);
                }
                case 51: {
                    return OFBsnGetSwitchPipelineRequestVer15.READER.readFrom(bb);
                }
                case 43: {
                    return OFBsnLacpConvergenceNotifVer15.READER.readFrom(bb);
                }
                case 63: {
                    return OFBsnLogVer15.READER.readFrom(bb);
                }
                case 66: {
                    return OFBsnLuaCommandReplyVer15.READER.readFrom(bb);
                }
                case 65: {
                    return OFBsnLuaCommandRequestVer15.READER.readFrom(bb);
                }
                case 67: {
                    return OFBsnLuaNotificationVer15.READER.readFrom(bb);
                }
                case 64: {
                    return OFBsnLuaUploadVer15.READER.readFrom(bb);
                }
                case 59: {
                    return OFBsnSetAuxCxnsReplyVer15.READER.readFrom(bb);
                }
                case 58: {
                    return OFBsnSetAuxCxnsRequestVer15.READER.readFrom(bb);
                }
                case 42: {
                    return OFBsnSetLacpReplyVer15.READER.readFrom(bb);
                }
                case 41: {
                    return OFBsnSetLacpRequestVer15.READER.readFrom(bb);
                }
                case 54: {
                    return OFBsnSetSwitchPipelineReplyVer15.READER.readFrom(bb);
                }
                case 53: {
                    return OFBsnSetSwitchPipelineRequestVer15.READER.readFrom(bb);
                }
                case 61: {
                    return OFBsnTableSetBucketsSizeVer15.READER.readFrom(bb);
                }
                case 45: {
                    return OFBsnTimeReplyVer15.READER.readFrom(bb);
                }
                case 44: {
                    return OFBsnTimeRequestVer15.READER.readFrom(bb);
                }
                case 70: {
                    return OFBsnVlanCounterClearVer15.READER.readFrom(bb);
                }
                case 68: {
                    return OFBsnGenericAsyncVer15.READER.readFrom(bb);
                }
                case 71: {
                    return OFBsnGenericCommandVer15.READER.readFrom(bb);
                }
                case 72: {
                    return OFBsnGenericCommandReplyVer15.READER.readFrom(bb);
                }
                case 69: {
                    return OFBsnTakeoverVer15.READER.readFrom(bb);
                }
            }
            throw new OFParseError("Unknown value for discriminator subtype of class OFBsnHeaderVer15: " + subtype);
        }
    }
}

