/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnGentableEntryStatsEntry;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlv;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnTlvVer15;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnGentableEntryStatsEntryVer15
implements OFBsnGentableEntryStatsEntry {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnGentableEntryStatsEntryVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 4;
    static final int MAXIMUM_LENGTH = 65535;
    private static final List<OFBsnTlv> DEFAULT_KEY = ImmutableList.of();
    private static final List<OFBsnTlv> DEFAULT_STATS = ImmutableList.of();
    private final List<OFBsnTlv> key;
    private final List<OFBsnTlv> stats;
    static final OFBsnGentableEntryStatsEntryVer15 DEFAULT = new OFBsnGentableEntryStatsEntryVer15(DEFAULT_KEY, DEFAULT_STATS);
    static final Reader READER = new Reader();
    static final OFBsnGentableEntryStatsEntryVer15Funnel FUNNEL = new OFBsnGentableEntryStatsEntryVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnGentableEntryStatsEntryVer15(List<OFBsnTlv> key, List<OFBsnTlv> stats) {
        if (key == null) {
            throw new NullPointerException("OFBsnGentableEntryStatsEntryVer15: property key cannot be null");
        }
        if (stats == null) {
            throw new NullPointerException("OFBsnGentableEntryStatsEntryVer15: property stats cannot be null");
        }
        this.key = key;
        this.stats = stats;
    }

    @Override
    public List<OFBsnTlv> getKey() {
        return this.key;
    }

    @Override
    public List<OFBsnTlv> getStats() {
        return this.stats;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBsnGentableEntryStatsEntry.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnGentableEntryStatsEntryVer15(");
        b.append("key=").append(this.key);
        b.append(", ");
        b.append("stats=").append(this.stats);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnGentableEntryStatsEntryVer15 other = (OFBsnGentableEntryStatsEntryVer15)obj;
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        return !(this.stats == null ? other.stats != null : !this.stats.equals(other.stats));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.stats == null ? 0 : this.stats.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnGentableEntryStatsEntryVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnGentableEntryStatsEntryVer15 message) {
            int startIndex = bb.writerIndex();
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            int keyLengthIndex = bb.writerIndex();
            bb.writeShort(0);
            int keyStartIndex = bb.writerIndex();
            ChannelUtils.writeList(bb, message.key);
            int keyLength = bb.writerIndex() - keyStartIndex;
            bb.setShort(keyLengthIndex, keyLength);
            ChannelUtils.writeList(bb, message.stats);
            int length = bb.writerIndex() - startIndex;
            if (length > 65535) {
                throw new IllegalArgumentException("OFBsnGentableEntryStatsEntryVer15: message length (" + length + ") exceeds maximum (0xFFFF)");
            }
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFBsnGentableEntryStatsEntryVer15Funnel
    implements Funnel<OFBsnGentableEntryStatsEntryVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnGentableEntryStatsEntryVer15Funnel() {
        }

        public void funnel(OFBsnGentableEntryStatsEntryVer15 message, PrimitiveSink sink) {
            FunnelUtils.putList(message.key, sink);
            FunnelUtils.putList(message.stats, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnGentableEntryStatsEntry> {
        Reader() {
        }

        @Override
        public OFBsnGentableEntryStatsEntry readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            int length = U16.f(bb.readShort());
            if (length < 4) {
                throw new OFParseError("Wrong length: Expected to be >= 4, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            int keyLength = U16.f(bb.readShort());
            List<OFBsnTlv> key = ChannelUtils.readList(bb, keyLength, OFBsnTlvVer15.READER);
            List<OFBsnTlv> stats = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFBsnTlvVer15.READER);
            OFBsnGentableEntryStatsEntryVer15 bsnGentableEntryStatsEntryVer15 = new OFBsnGentableEntryStatsEntryVer15(key, stats);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnGentableEntryStatsEntryVer15);
            }
            return bsnGentableEntryStatsEntryVer15;
        }
    }

    static class Builder
    implements OFBsnGentableEntryStatsEntry.Builder {
        private boolean keySet;
        private List<OFBsnTlv> key;
        private boolean statsSet;
        private List<OFBsnTlv> stats;

        Builder() {
        }

        @Override
        public List<OFBsnTlv> getKey() {
            return this.key;
        }

        @Override
        public OFBsnGentableEntryStatsEntry.Builder setKey(List<OFBsnTlv> key) {
            this.key = key;
            this.keySet = true;
            return this;
        }

        @Override
        public List<OFBsnTlv> getStats() {
            return this.stats;
        }

        @Override
        public OFBsnGentableEntryStatsEntry.Builder setStats(List<OFBsnTlv> stats) {
            this.stats = stats;
            this.statsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnGentableEntryStatsEntry build() {
            List<OFBsnTlv> stats;
            List<OFBsnTlv> key;
            List<OFBsnTlv> list = key = this.keySet ? this.key : DEFAULT_KEY;
            if (key == null) {
                throw new NullPointerException("Property key must not be null");
            }
            List<OFBsnTlv> list2 = stats = this.statsSet ? this.stats : DEFAULT_STATS;
            if (stats == null) {
                throw new NullPointerException("Property stats must not be null");
            }
            return new OFBsnGentableEntryStatsEntryVer15(key, stats);
        }
    }

    static class BuilderWithParent
    implements OFBsnGentableEntryStatsEntry.Builder {
        final OFBsnGentableEntryStatsEntryVer15 parentMessage;
        private boolean keySet;
        private List<OFBsnTlv> key;
        private boolean statsSet;
        private List<OFBsnTlv> stats;

        BuilderWithParent(OFBsnGentableEntryStatsEntryVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public List<OFBsnTlv> getKey() {
            return this.key;
        }

        @Override
        public OFBsnGentableEntryStatsEntry.Builder setKey(List<OFBsnTlv> key) {
            this.key = key;
            this.keySet = true;
            return this;
        }

        @Override
        public List<OFBsnTlv> getStats() {
            return this.stats;
        }

        @Override
        public OFBsnGentableEntryStatsEntry.Builder setStats(List<OFBsnTlv> stats) {
            this.stats = stats;
            this.statsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnGentableEntryStatsEntry build() {
            List stats;
            List key;
            List list = key = this.keySet ? this.key : this.parentMessage.key;
            if (key == null) {
                throw new NullPointerException("Property key must not be null");
            }
            List list2 = stats = this.statsSet ? this.stats : this.parentMessage.stats;
            if (stats == null) {
                throw new NullPointerException("Property stats must not be null");
            }
            return new OFBsnGentableEntryStatsEntryVer15(key, stats);
        }
    }
}

