/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnGentableBucketStatsEntry;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U128;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnGentableBucketStatsEntryVer15
implements OFBsnGentableBucketStatsEntry {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnGentableBucketStatsEntryVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 16;
    private static final U128 DEFAULT_CHECKSUM = U128.ZERO;
    private final U128 checksum;
    static final OFBsnGentableBucketStatsEntryVer15 DEFAULT = new OFBsnGentableBucketStatsEntryVer15(DEFAULT_CHECKSUM);
    static final Reader READER = new Reader();
    static final OFBsnGentableBucketStatsEntryVer15Funnel FUNNEL = new OFBsnGentableBucketStatsEntryVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnGentableBucketStatsEntryVer15(U128 checksum) {
        if (checksum == null) {
            throw new NullPointerException("OFBsnGentableBucketStatsEntryVer15: property checksum cannot be null");
        }
        this.checksum = checksum;
    }

    @Override
    public U128 getChecksum() {
        return this.checksum;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBsnGentableBucketStatsEntry.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnGentableBucketStatsEntryVer15(");
        b.append("checksum=").append(this.checksum);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnGentableBucketStatsEntryVer15 other = (OFBsnGentableBucketStatsEntryVer15)obj;
        return !(this.checksum == null ? other.checksum != null : !this.checksum.equals(other.checksum));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.checksum == null ? 0 : this.checksum.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnGentableBucketStatsEntryVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnGentableBucketStatsEntryVer15 message) {
            message.checksum.write16Bytes(bb);
        }
    }

    static class OFBsnGentableBucketStatsEntryVer15Funnel
    implements Funnel<OFBsnGentableBucketStatsEntryVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnGentableBucketStatsEntryVer15Funnel() {
        }

        public void funnel(OFBsnGentableBucketStatsEntryVer15 message, PrimitiveSink sink) {
            message.checksum.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnGentableBucketStatsEntry> {
        Reader() {
        }

        @Override
        public OFBsnGentableBucketStatsEntry readFrom(ByteBuf bb) throws OFParseError {
            U128 checksum = U128.read16Bytes(bb);
            OFBsnGentableBucketStatsEntryVer15 bsnGentableBucketStatsEntryVer15 = new OFBsnGentableBucketStatsEntryVer15(checksum);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnGentableBucketStatsEntryVer15);
            }
            return bsnGentableBucketStatsEntryVer15;
        }
    }

    static class Builder
    implements OFBsnGentableBucketStatsEntry.Builder {
        private boolean checksumSet;
        private U128 checksum;

        Builder() {
        }

        @Override
        public U128 getChecksum() {
            return this.checksum;
        }

        @Override
        public OFBsnGentableBucketStatsEntry.Builder setChecksum(U128 checksum) {
            this.checksum = checksum;
            this.checksumSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnGentableBucketStatsEntry build() {
            U128 checksum;
            U128 u128 = checksum = this.checksumSet ? this.checksum : DEFAULT_CHECKSUM;
            if (checksum == null) {
                throw new NullPointerException("Property checksum must not be null");
            }
            return new OFBsnGentableBucketStatsEntryVer15(checksum);
        }
    }

    static class BuilderWithParent
    implements OFBsnGentableBucketStatsEntry.Builder {
        final OFBsnGentableBucketStatsEntryVer15 parentMessage;
        private boolean checksumSet;
        private U128 checksum;

        BuilderWithParent(OFBsnGentableBucketStatsEntryVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public U128 getChecksum() {
            return this.checksum;
        }

        @Override
        public OFBsnGentableBucketStatsEntry.Builder setChecksum(U128 checksum) {
            this.checksum = checksum;
            this.checksumSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnGentableBucketStatsEntry build() {
            U128 checksum;
            U128 u128 = checksum = this.checksumSet ? this.checksum : this.parentMessage.checksum;
            if (checksum == null) {
                throw new NullPointerException("Property checksum must not be null");
            }
            return new OFBsnGentableBucketStatsEntryVer15(checksum);
        }
    }
}

