/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnFlowIdleEnableGetReply;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnFlowIdleEnableGetReplyVer15
implements OFBsnFlowIdleEnableGetReply {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnFlowIdleEnableGetReplyVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 20;
    private static final long DEFAULT_XID = 0L;
    private static final long DEFAULT_ENABLED = 0L;
    private final long xid;
    private final long enabled;
    static final OFBsnFlowIdleEnableGetReplyVer15 DEFAULT = new OFBsnFlowIdleEnableGetReplyVer15(0L, 0L);
    static final Reader READER = new Reader();
    static final OFBsnFlowIdleEnableGetReplyVer15Funnel FUNNEL = new OFBsnFlowIdleEnableGetReplyVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnFlowIdleEnableGetReplyVer15(long xid, long enabled) {
        this.xid = U32.normalize(xid);
        this.enabled = U32.normalize(enabled);
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 39L;
    }

    @Override
    public long getEnabled() {
        return this.enabled;
    }

    @Override
    public OFBsnFlowIdleEnableGetReply.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnFlowIdleEnableGetReplyVer15(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("enabled=").append(this.enabled);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnFlowIdleEnableGetReplyVer15 other = (OFBsnFlowIdleEnableGetReplyVer15)obj;
        if (this.xid != other.xid) {
            return false;
        }
        return this.enabled == other.enabled;
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnFlowIdleEnableGetReplyVer15 other = (OFBsnFlowIdleEnableGetReplyVer15)obj;
        return this.enabled == other.enabled;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * (int)(this.enabled ^ this.enabled >>> 32);
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.enabled ^ this.enabled >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnFlowIdleEnableGetReplyVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnFlowIdleEnableGetReplyVer15 message) {
            bb.writeByte(6);
            bb.writeByte(4);
            bb.writeShort(20);
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(6035143);
            bb.writeInt(39);
            bb.writeInt(U32.t(message.enabled));
        }
    }

    static class OFBsnFlowIdleEnableGetReplyVer15Funnel
    implements Funnel<OFBsnFlowIdleEnableGetReplyVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnFlowIdleEnableGetReplyVer15Funnel() {
        }

        public void funnel(OFBsnFlowIdleEnableGetReplyVer15 message, PrimitiveSink sink) {
            sink.putByte((byte)6);
            sink.putByte((byte)4);
            sink.putShort((short)20);
            sink.putLong(message.xid);
            sink.putInt(6035143);
            sink.putInt(39);
            sink.putLong(message.enabled);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnFlowIdleEnableGetReply> {
        Reader() {
        }

        @Override
        public OFBsnFlowIdleEnableGetReply readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 6) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_15(6), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 20) {
                throw new OFParseError("Wrong length: Expected=20(20), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 39) {
                throw new OFParseError("Wrong subtype: Expected=0x27L(0x27L), got=" + subtype);
            }
            long enabled = U32.f(bb.readInt());
            OFBsnFlowIdleEnableGetReplyVer15 bsnFlowIdleEnableGetReplyVer15 = new OFBsnFlowIdleEnableGetReplyVer15(xid, enabled);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnFlowIdleEnableGetReplyVer15);
            }
            return bsnFlowIdleEnableGetReplyVer15;
        }
    }

    static class Builder
    implements OFBsnFlowIdleEnableGetReply.Builder {
        private boolean xidSet;
        private long xid;
        private boolean enabledSet;
        private long enabled;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnFlowIdleEnableGetReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 39L;
        }

        @Override
        public long getEnabled() {
            return this.enabled;
        }

        @Override
        public OFBsnFlowIdleEnableGetReply.Builder setEnabled(long enabled) {
            this.enabled = enabled;
            this.enabledSet = true;
            return this;
        }

        @Override
        public OFBsnFlowIdleEnableGetReply build() {
            long xid = this.xidSet ? this.xid : 0L;
            long enabled = this.enabledSet ? this.enabled : 0L;
            return new OFBsnFlowIdleEnableGetReplyVer15(xid, enabled);
        }
    }

    static class BuilderWithParent
    implements OFBsnFlowIdleEnableGetReply.Builder {
        final OFBsnFlowIdleEnableGetReplyVer15 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean enabledSet;
        private long enabled;

        BuilderWithParent(OFBsnFlowIdleEnableGetReplyVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnFlowIdleEnableGetReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 39L;
        }

        @Override
        public long getEnabled() {
            return this.enabled;
        }

        @Override
        public OFBsnFlowIdleEnableGetReply.Builder setEnabled(long enabled) {
            this.enabled = enabled;
            this.enabledSet = true;
            return this;
        }

        @Override
        public OFBsnFlowIdleEnableGetReply build() {
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            long enabled = this.enabledSet ? this.enabled : this.parentMessage.enabled;
            return new OFBsnFlowIdleEnableGetReplyVer15(xid, enabled);
        }
    }
}

