/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFAsyncConfigPropRoleStatusMaster;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFAsyncConfigPropRoleStatusMasterVer15
implements OFAsyncConfigPropRoleStatusMaster {
    private static final Logger logger = LoggerFactory.getLogger(OFAsyncConfigPropRoleStatusMasterVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 8;
    private static final long DEFAULT_MASK = 0L;
    private final long mask;
    static final OFAsyncConfigPropRoleStatusMasterVer15 DEFAULT = new OFAsyncConfigPropRoleStatusMasterVer15(0L);
    static final Reader READER = new Reader();
    static final OFAsyncConfigPropRoleStatusMasterVer15Funnel FUNNEL = new OFAsyncConfigPropRoleStatusMasterVer15Funnel();
    static final Writer WRITER = new Writer();

    OFAsyncConfigPropRoleStatusMasterVer15(long mask) {
        this.mask = U32.normalize(mask);
    }

    @Override
    public int getType() {
        return 7;
    }

    @Override
    public long getMask() {
        return this.mask;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFAsyncConfigPropRoleStatusMaster.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFAsyncConfigPropRoleStatusMasterVer15(");
        b.append("mask=").append(this.mask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFAsyncConfigPropRoleStatusMasterVer15 other = (OFAsyncConfigPropRoleStatusMasterVer15)obj;
        return this.mask == other.mask;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.mask ^ this.mask >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFAsyncConfigPropRoleStatusMasterVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFAsyncConfigPropRoleStatusMasterVer15 message) {
            bb.writeShort(7);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.mask));
        }
    }

    static class OFAsyncConfigPropRoleStatusMasterVer15Funnel
    implements Funnel<OFAsyncConfigPropRoleStatusMasterVer15> {
        private static final long serialVersionUID = 1L;

        OFAsyncConfigPropRoleStatusMasterVer15Funnel() {
        }

        public void funnel(OFAsyncConfigPropRoleStatusMasterVer15 message, PrimitiveSink sink) {
            sink.putShort((short)7);
            sink.putShort((short)8);
            sink.putLong(message.mask);
        }
    }

    static class Reader
    implements OFMessageReader<OFAsyncConfigPropRoleStatusMaster> {
        Reader() {
        }

        @Override
        public OFAsyncConfigPropRoleStatusMaster readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 7) {
                throw new OFParseError("Wrong type: Expected=0x7(0x7), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long mask = U32.f(bb.readInt());
            OFAsyncConfigPropRoleStatusMasterVer15 asyncConfigPropRoleStatusMasterVer15 = new OFAsyncConfigPropRoleStatusMasterVer15(mask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)asyncConfigPropRoleStatusMasterVer15);
            }
            return asyncConfigPropRoleStatusMasterVer15;
        }
    }

    static class Builder
    implements OFAsyncConfigPropRoleStatusMaster.Builder {
        private boolean maskSet;
        private long mask;

        Builder() {
        }

        @Override
        public int getType() {
            return 7;
        }

        @Override
        public long getMask() {
            return this.mask;
        }

        @Override
        public OFAsyncConfigPropRoleStatusMaster.Builder setMask(long mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFAsyncConfigPropRoleStatusMaster build() {
            long mask = this.maskSet ? this.mask : 0L;
            return new OFAsyncConfigPropRoleStatusMasterVer15(mask);
        }
    }

    static class BuilderWithParent
    implements OFAsyncConfigPropRoleStatusMaster.Builder {
        final OFAsyncConfigPropRoleStatusMasterVer15 parentMessage;
        private boolean maskSet;
        private long mask;

        BuilderWithParent(OFAsyncConfigPropRoleStatusMasterVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 7;
        }

        @Override
        public long getMask() {
            return this.mask;
        }

        @Override
        public OFAsyncConfigPropRoleStatusMaster.Builder setMask(long mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFAsyncConfigPropRoleStatusMaster build() {
            long mask = this.maskSet ? this.mask : this.parentMessage.mask;
            return new OFAsyncConfigPropRoleStatusMasterVer15(mask);
        }
    }
}

