/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.actionid.OFActionIdOutput;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionIdOutputVer15
implements OFActionIdOutput {
    private static final Logger logger = LoggerFactory.getLogger(OFActionIdOutputVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 4;
    static final OFActionIdOutputVer15 DEFAULT = new OFActionIdOutputVer15();
    static final OFActionIdOutputVer15 INSTANCE = new OFActionIdOutputVer15();
    static final Reader READER = new Reader();
    static final OFActionIdOutputVer15Funnel FUNNEL = new OFActionIdOutputVer15Funnel();
    static final Writer WRITER = new Writer();

    private OFActionIdOutputVer15() {
    }

    @Override
    public OFActionType getType() {
        return OFActionType.OUTPUT;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFActionIdOutput.Builder createBuilder() {
        throw new UnsupportedOperationException("OFActionIdOutputVer15 has no mutable properties -- builder unneeded");
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionIdOutputVer15(");
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionIdOutputVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFActionIdOutputVer15 message) {
            bb.writeShort(0);
            bb.writeShort(4);
        }
    }

    static class OFActionIdOutputVer15Funnel
    implements Funnel<OFActionIdOutputVer15> {
        private static final long serialVersionUID = 1L;

        OFActionIdOutputVer15Funnel() {
        }

        public void funnel(OFActionIdOutputVer15 message, PrimitiveSink sink) {
            sink.putShort((short)0);
            sink.putShort((short)4);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionIdOutput> {
        Reader() {
        }

        @Override
        public OFActionIdOutput readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 0) {
                throw new OFParseError("Wrong type: Expected=OFActionType.OUTPUT(0), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 4) {
                throw new OFParseError("Wrong length: Expected=4(4), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - returning shared instance={}", (Object)INSTANCE);
            }
            return INSTANCE;
        }
    }
}

