/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.actionid.OFActionIdNicira;
import org.projectfloodlight.openflow.protocol.ver15.OFActionIdNiciraDecTtlVer15;
import org.projectfloodlight.openflow.types.U16;

abstract class OFActionIdNiciraVer15 {
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 10;
    public static final Reader READER = new Reader();

    OFActionIdNiciraVer15() {
    }

    static class Reader
    implements OFMessageReader<OFActionIdNicira> {
        Reader() {
        }

        @Override
        public OFActionIdNicira readFrom(ByteBuf bb) throws OFParseError {
            if (bb.readableBytes() < 10) {
                return null;
            }
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != -1) {
                throw new OFParseError("Wrong type: Expected=OFActionType.EXPERIMENTER(65535), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 10) {
                throw new OFParseError("Wrong length: Expected to be >= 10, was: " + length);
            }
            int experimenter = bb.readInt();
            if (experimenter != 8992) {
                throw new OFParseError("Wrong experimenter: Expected=0x2320L(0x2320L), got=" + experimenter);
            }
            short subtype = bb.readShort();
            bb.readerIndex(start);
            switch (subtype) {
                case 18: {
                    return OFActionIdNiciraDecTtlVer15.READER.readFrom(bb);
                }
            }
            throw new OFParseError("Unknown value for discriminator subtype of class OFActionIdNiciraVer15: " + subtype);
        }
    }
}

