/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.actionid.OFActionIdExperimenter;
import org.projectfloodlight.openflow.protocol.ver15.OFActionIdBsnVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFActionIdNiciraVer15;
import org.projectfloodlight.openflow.types.U16;

abstract class OFActionIdExperimenterVer15 {
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 8;
    public static final Reader READER = new Reader();

    OFActionIdExperimenterVer15() {
    }

    static class Reader
    implements OFMessageReader<OFActionIdExperimenter> {
        Reader() {
        }

        @Override
        public OFActionIdExperimenter readFrom(ByteBuf bb) throws OFParseError {
            if (bb.readableBytes() < 8) {
                return null;
            }
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != -1) {
                throw new OFParseError("Wrong type: Expected=OFActionType.EXPERIMENTER(65535), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 8) {
                throw new OFParseError("Wrong length: Expected to be >= 8, was: " + length);
            }
            int experimenter = bb.readInt();
            bb.readerIndex(start);
            switch (experimenter) {
                case 6035143: {
                    return OFActionIdBsnVer15.READER.readFrom(bb);
                }
                case 8992: {
                    return OFActionIdNiciraVer15.READER.readFrom(bb);
                }
            }
            throw new OFParseError("Unknown value for discriminator experimenter of class OFActionIdExperimenterVer15: " + experimenter);
        }
    }
}

