/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFTableMod;
import org.projectfloodlight.openflow.protocol.OFTableModProp;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver14.OFTableModPropVer14;
import org.projectfloodlight.openflow.types.TableId;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFTableModVer14
implements OFTableMod {
    private static final Logger logger = LoggerFactory.getLogger(OFTableModVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int MINIMUM_LENGTH = 16;
    static final int MAXIMUM_LENGTH = 65535;
    private static final long DEFAULT_XID = 0L;
    private static final TableId DEFAULT_TABLE_ID = TableId.ALL;
    private static final long DEFAULT_CONFIG = 0L;
    private static final List<OFTableModProp> DEFAULT_PROPERTIES = ImmutableList.of();
    private final long xid;
    private final TableId tableId;
    private final long config;
    private final List<OFTableModProp> properties;
    static final OFTableModVer14 DEFAULT = new OFTableModVer14(0L, DEFAULT_TABLE_ID, 0L, DEFAULT_PROPERTIES);
    static final Reader READER = new Reader();
    static final OFTableModVer14Funnel FUNNEL = new OFTableModVer14Funnel();
    static final Writer WRITER = new Writer();

    OFTableModVer14(long xid, TableId tableId, long config, List<OFTableModProp> properties) {
        if (tableId == null) {
            throw new NullPointerException("OFTableModVer14: property tableId cannot be null");
        }
        if (properties == null) {
            throw new NullPointerException("OFTableModVer14: property properties cannot be null");
        }
        this.xid = U32.normalize(xid);
        this.tableId = tableId;
        this.config = U32.normalize(config);
        this.properties = properties;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFType getType() {
        return OFType.TABLE_MOD;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public TableId getTableId() {
        return this.tableId;
    }

    @Override
    public long getConfig() {
        return this.config;
    }

    @Override
    public List<OFTableModProp> getProperties() {
        return this.properties;
    }

    @Override
    public OFTableMod.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFTableModVer14(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("tableId=").append(this.tableId);
        b.append(", ");
        b.append("config=").append(this.config);
        b.append(", ");
        b.append("properties=").append(this.properties);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFTableModVer14 other = (OFTableModVer14)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.tableId == null ? other.tableId != null : !this.tableId.equals(other.tableId)) {
            return false;
        }
        if (this.config != other.config) {
            return false;
        }
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFTableModVer14 other = (OFTableModVer14)obj;
        if (this.tableId == null ? other.tableId != null : !this.tableId.equals(other.tableId)) {
            return false;
        }
        if (this.config != other.config) {
            return false;
        }
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.tableId == null ? 0 : this.tableId.hashCode());
        result = 31 * (int)(this.config ^ this.config >>> 32);
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.tableId == null ? 0 : this.tableId.hashCode());
        result = 31 * (int)(this.config ^ this.config >>> 32);
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFTableModVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFTableModVer14 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(5);
            bb.writeByte(17);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            message.tableId.writeByte(bb);
            bb.writeZero(3);
            bb.writeInt(U32.t(message.config));
            ChannelUtils.writeList(bb, message.properties);
            int length = bb.writerIndex() - startIndex;
            if (length > 65535) {
                throw new IllegalArgumentException("OFTableModVer14: message length (" + length + ") exceeds maximum (0xFFFF)");
            }
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFTableModVer14Funnel
    implements Funnel<OFTableModVer14> {
        private static final long serialVersionUID = 1L;

        OFTableModVer14Funnel() {
        }

        public void funnel(OFTableModVer14 message, PrimitiveSink sink) {
            sink.putByte((byte)5);
            sink.putByte((byte)17);
            sink.putLong(message.xid);
            message.tableId.putTo(sink);
            sink.putLong(message.config);
            FunnelUtils.putList(message.properties, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFTableMod> {
        Reader() {
        }

        @Override
        public OFTableMod readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 5) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_14(5), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 17) {
                throw new OFParseError("Wrong type: Expected=OFType.TABLE_MOD(17), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 16) {
                throw new OFParseError("Wrong length: Expected to be >= 16, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            TableId tableId = TableId.readByte(bb);
            bb.skipBytes(3);
            long config = U32.f(bb.readInt());
            List<OFTableModProp> properties = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFTableModPropVer14.READER);
            OFTableModVer14 tableModVer14 = new OFTableModVer14(xid, tableId, config, properties);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)tableModVer14);
            }
            return tableModVer14;
        }
    }

    static class Builder
    implements OFTableMod.Builder {
        private boolean xidSet;
        private long xid;
        private boolean tableIdSet;
        private TableId tableId;
        private boolean configSet;
        private long config;
        private boolean propertiesSet;
        private List<OFTableModProp> properties;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFType getType() {
            return OFType.TABLE_MOD;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFTableMod.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public TableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFTableMod.Builder setTableId(TableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public long getConfig() {
            return this.config;
        }

        @Override
        public OFTableMod.Builder setConfig(long config) {
            this.config = config;
            this.configSet = true;
            return this;
        }

        @Override
        public List<OFTableModProp> getProperties() {
            return this.properties;
        }

        @Override
        public OFTableMod.Builder setProperties(List<OFTableModProp> properties) {
            this.properties = properties;
            this.propertiesSet = true;
            return this;
        }

        @Override
        public OFTableMod build() {
            List<OFTableModProp> properties;
            TableId tableId;
            long xid = this.xidSet ? this.xid : 0L;
            TableId tableId2 = tableId = this.tableIdSet ? this.tableId : DEFAULT_TABLE_ID;
            if (tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            long config = this.configSet ? this.config : 0L;
            List<OFTableModProp> list = properties = this.propertiesSet ? this.properties : DEFAULT_PROPERTIES;
            if (properties == null) {
                throw new NullPointerException("Property properties must not be null");
            }
            return new OFTableModVer14(xid, tableId, config, properties);
        }
    }

    static class BuilderWithParent
    implements OFTableMod.Builder {
        final OFTableModVer14 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean tableIdSet;
        private TableId tableId;
        private boolean configSet;
        private long config;
        private boolean propertiesSet;
        private List<OFTableModProp> properties;

        BuilderWithParent(OFTableModVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFType getType() {
            return OFType.TABLE_MOD;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFTableMod.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public TableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFTableMod.Builder setTableId(TableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public long getConfig() {
            return this.config;
        }

        @Override
        public OFTableMod.Builder setConfig(long config) {
            this.config = config;
            this.configSet = true;
            return this;
        }

        @Override
        public List<OFTableModProp> getProperties() {
            return this.properties;
        }

        @Override
        public OFTableMod.Builder setProperties(List<OFTableModProp> properties) {
            this.properties = properties;
            this.propertiesSet = true;
            return this;
        }

        @Override
        public OFTableMod build() {
            List properties;
            TableId tableId;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            TableId tableId2 = tableId = this.tableIdSet ? this.tableId : this.parentMessage.tableId;
            if (tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            long config = this.configSet ? this.config : this.parentMessage.config;
            List list = properties = this.propertiesSet ? this.properties : this.parentMessage.properties;
            if (properties == null) {
                throw new NullPointerException("Property properties must not be null");
            }
            return new OFTableModVer14(xid, tableId, config, properties);
        }
    }
}

