/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFTableFeaturePropMatch;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFTableFeaturePropMatchVer14
implements OFTableFeaturePropMatch {
    private static final Logger logger = LoggerFactory.getLogger(OFTableFeaturePropMatchVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int MINIMUM_LENGTH = 4;
    static final int MAXIMUM_LENGTH = 65535;
    private static final List<U32> DEFAULT_OXM_IDS = ImmutableList.of();
    private final List<U32> oxmIds;
    static final OFTableFeaturePropMatchVer14 DEFAULT = new OFTableFeaturePropMatchVer14(DEFAULT_OXM_IDS);
    static final Reader READER = new Reader();
    static final OFTableFeaturePropMatchVer14Funnel FUNNEL = new OFTableFeaturePropMatchVer14Funnel();
    static final Writer WRITER = new Writer();

    OFTableFeaturePropMatchVer14(List<U32> oxmIds) {
        if (oxmIds == null) {
            throw new NullPointerException("OFTableFeaturePropMatchVer14: property oxmIds cannot be null");
        }
        this.oxmIds = oxmIds;
    }

    @Override
    public int getType() {
        return 8;
    }

    @Override
    public List<U32> getOxmIds() {
        return this.oxmIds;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFTableFeaturePropMatch.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFTableFeaturePropMatchVer14(");
        b.append("oxmIds=").append(this.oxmIds);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFTableFeaturePropMatchVer14 other = (OFTableFeaturePropMatchVer14)obj;
        return !(this.oxmIds == null ? other.oxmIds != null : !this.oxmIds.equals(other.oxmIds));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.oxmIds == null ? 0 : this.oxmIds.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFTableFeaturePropMatchVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFTableFeaturePropMatchVer14 message) {
            int startIndex = bb.writerIndex();
            bb.writeShort(8);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            ChannelUtils.writeList(bb, message.oxmIds);
            int length = bb.writerIndex() - startIndex;
            int alignedLength = (length + 7) / 8 * 8;
            if (length > 65535) {
                throw new IllegalArgumentException("OFTableFeaturePropMatchVer14: message length (" + length + ") exceeds maximum (0xFFFF)");
            }
            bb.setShort(lengthIndex, length);
            bb.writeZero(alignedLength - length);
        }
    }

    static class OFTableFeaturePropMatchVer14Funnel
    implements Funnel<OFTableFeaturePropMatchVer14> {
        private static final long serialVersionUID = 1L;

        OFTableFeaturePropMatchVer14Funnel() {
        }

        public void funnel(OFTableFeaturePropMatchVer14 message, PrimitiveSink sink) {
            sink.putShort((short)8);
            FunnelUtils.putList(message.oxmIds, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFTableFeaturePropMatch> {
        Reader() {
        }

        @Override
        public OFTableFeaturePropMatch readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 8) {
                throw new OFParseError("Wrong type: Expected=0x8(0x8), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 4) {
                throw new OFParseError("Wrong length: Expected to be >= 4, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            List<U32> oxmIds = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), U32.READER);
            bb.skipBytes((length + 7) / 8 * 8 - length);
            OFTableFeaturePropMatchVer14 tableFeaturePropMatchVer14 = new OFTableFeaturePropMatchVer14(oxmIds);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)tableFeaturePropMatchVer14);
            }
            return tableFeaturePropMatchVer14;
        }
    }

    static class Builder
    implements OFTableFeaturePropMatch.Builder {
        private boolean oxmIdsSet;
        private List<U32> oxmIds;

        Builder() {
        }

        @Override
        public int getType() {
            return 8;
        }

        @Override
        public List<U32> getOxmIds() {
            return this.oxmIds;
        }

        @Override
        public OFTableFeaturePropMatch.Builder setOxmIds(List<U32> oxmIds) {
            this.oxmIds = oxmIds;
            this.oxmIdsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFTableFeaturePropMatch build() {
            List<U32> oxmIds;
            List<U32> list = oxmIds = this.oxmIdsSet ? this.oxmIds : DEFAULT_OXM_IDS;
            if (oxmIds == null) {
                throw new NullPointerException("Property oxmIds must not be null");
            }
            return new OFTableFeaturePropMatchVer14(oxmIds);
        }
    }

    static class BuilderWithParent
    implements OFTableFeaturePropMatch.Builder {
        final OFTableFeaturePropMatchVer14 parentMessage;
        private boolean oxmIdsSet;
        private List<U32> oxmIds;

        BuilderWithParent(OFTableFeaturePropMatchVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 8;
        }

        @Override
        public List<U32> getOxmIds() {
            return this.oxmIds;
        }

        @Override
        public OFTableFeaturePropMatch.Builder setOxmIds(List<U32> oxmIds) {
            this.oxmIds = oxmIds;
            this.oxmIdsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFTableFeaturePropMatch build() {
            List oxmIds;
            List list = oxmIds = this.oxmIdsSet ? this.oxmIds : this.parentMessage.oxmIds;
            if (oxmIds == null) {
                throw new NullPointerException("Property oxmIds must not be null");
            }
            return new OFTableFeaturePropMatchVer14(oxmIds);
        }
    }
}

