/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFPortDescPropBsnBreakout;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFPortDescPropBsnBreakoutVer14
implements OFPortDescPropBsnBreakout {
    private static final Logger logger = LoggerFactory.getLogger(OFPortDescPropBsnBreakoutVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 16;
    private static final int DEFAULT_SUB_INTERFACE_COUNT = 0;
    private static final int DEFAULT_SUB_INTERFACE_SPEED_GBPS = 0;
    private final int subInterfaceCount;
    private final int subInterfaceSpeedGbps;
    static final OFPortDescPropBsnBreakoutVer14 DEFAULT = new OFPortDescPropBsnBreakoutVer14(0, 0);
    static final Reader READER = new Reader();
    static final OFPortDescPropBsnBreakoutVer14Funnel FUNNEL = new OFPortDescPropBsnBreakoutVer14Funnel();
    static final Writer WRITER = new Writer();

    OFPortDescPropBsnBreakoutVer14(int subInterfaceCount, int subInterfaceSpeedGbps) {
        this.subInterfaceCount = U16.normalize(subInterfaceCount);
        this.subInterfaceSpeedGbps = U16.normalize(subInterfaceSpeedGbps);
    }

    @Override
    public int getType() {
        return 65535;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getExpType() {
        return 3L;
    }

    @Override
    public int getSubInterfaceCount() {
        return this.subInterfaceCount;
    }

    @Override
    public int getSubInterfaceSpeedGbps() {
        return this.subInterfaceSpeedGbps;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFPortDescPropBsnBreakout.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFPortDescPropBsnBreakoutVer14(");
        b.append("subInterfaceCount=").append(this.subInterfaceCount);
        b.append(", ");
        b.append("subInterfaceSpeedGbps=").append(this.subInterfaceSpeedGbps);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFPortDescPropBsnBreakoutVer14 other = (OFPortDescPropBsnBreakoutVer14)obj;
        if (this.subInterfaceCount != other.subInterfaceCount) {
            return false;
        }
        return this.subInterfaceSpeedGbps == other.subInterfaceSpeedGbps;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.subInterfaceCount;
        result = 31 * result + this.subInterfaceSpeedGbps;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFPortDescPropBsnBreakoutVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFPortDescPropBsnBreakoutVer14 message) {
            bb.writeShort(-1);
            bb.writeShort(16);
            bb.writeInt(6035143);
            bb.writeInt(3);
            bb.writeShort((int)U16.t(message.subInterfaceCount));
            bb.writeShort((int)U16.t(message.subInterfaceSpeedGbps));
        }
    }

    static class OFPortDescPropBsnBreakoutVer14Funnel
    implements Funnel<OFPortDescPropBsnBreakoutVer14> {
        private static final long serialVersionUID = 1L;

        OFPortDescPropBsnBreakoutVer14Funnel() {
        }

        public void funnel(OFPortDescPropBsnBreakoutVer14 message, PrimitiveSink sink) {
            sink.putShort((short)-1);
            sink.putShort((short)16);
            sink.putInt(6035143);
            sink.putInt(3);
            sink.putInt(message.subInterfaceCount);
            sink.putInt(message.subInterfaceSpeedGbps);
        }
    }

    static class Reader
    implements OFMessageReader<OFPortDescPropBsnBreakout> {
        Reader() {
        }

        @Override
        public OFPortDescPropBsnBreakout readFrom(ByteBuf bb) throws OFParseError {
            int experimenter;
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != -1) {
                throw new OFParseError("Wrong type: Expected=0xffff(0xffff), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 16) {
                throw new OFParseError("Wrong length: Expected=16(16), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if ((experimenter = bb.readInt()) != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int expType = bb.readInt();
            if (expType != 3) {
                throw new OFParseError("Wrong expType: Expected=0x3L(0x3L), got=" + expType);
            }
            int subInterfaceCount = U16.f(bb.readShort());
            int subInterfaceSpeedGbps = U16.f(bb.readShort());
            OFPortDescPropBsnBreakoutVer14 portDescPropBsnBreakoutVer14 = new OFPortDescPropBsnBreakoutVer14(subInterfaceCount, subInterfaceSpeedGbps);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)portDescPropBsnBreakoutVer14);
            }
            return portDescPropBsnBreakoutVer14;
        }
    }

    static class Builder
    implements OFPortDescPropBsnBreakout.Builder {
        private boolean subInterfaceCountSet;
        private int subInterfaceCount;
        private boolean subInterfaceSpeedGbpsSet;
        private int subInterfaceSpeedGbps;

        Builder() {
        }

        @Override
        public int getType() {
            return 65535;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getExpType() {
            return 3L;
        }

        @Override
        public OFPortDescPropBsnBreakout.Builder setExpType(long expType) {
            throw new UnsupportedOperationException("Property expType is not writeable");
        }

        @Override
        public int getSubInterfaceCount() {
            return this.subInterfaceCount;
        }

        @Override
        public OFPortDescPropBsnBreakout.Builder setSubInterfaceCount(int subInterfaceCount) {
            this.subInterfaceCount = subInterfaceCount;
            this.subInterfaceCountSet = true;
            return this;
        }

        @Override
        public int getSubInterfaceSpeedGbps() {
            return this.subInterfaceSpeedGbps;
        }

        @Override
        public OFPortDescPropBsnBreakout.Builder setSubInterfaceSpeedGbps(int subInterfaceSpeedGbps) {
            this.subInterfaceSpeedGbps = subInterfaceSpeedGbps;
            this.subInterfaceSpeedGbpsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFPortDescPropBsnBreakout build() {
            int subInterfaceCount = this.subInterfaceCountSet ? this.subInterfaceCount : 0;
            int subInterfaceSpeedGbps = this.subInterfaceSpeedGbpsSet ? this.subInterfaceSpeedGbps : 0;
            return new OFPortDescPropBsnBreakoutVer14(subInterfaceCount, subInterfaceSpeedGbps);
        }
    }

    static class BuilderWithParent
    implements OFPortDescPropBsnBreakout.Builder {
        final OFPortDescPropBsnBreakoutVer14 parentMessage;
        private boolean subInterfaceCountSet;
        private int subInterfaceCount;
        private boolean subInterfaceSpeedGbpsSet;
        private int subInterfaceSpeedGbps;

        BuilderWithParent(OFPortDescPropBsnBreakoutVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 65535;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getExpType() {
            return 3L;
        }

        @Override
        public OFPortDescPropBsnBreakout.Builder setExpType(long expType) {
            throw new UnsupportedOperationException("Property expType is not writeable");
        }

        @Override
        public int getSubInterfaceCount() {
            return this.subInterfaceCount;
        }

        @Override
        public OFPortDescPropBsnBreakout.Builder setSubInterfaceCount(int subInterfaceCount) {
            this.subInterfaceCount = subInterfaceCount;
            this.subInterfaceCountSet = true;
            return this;
        }

        @Override
        public int getSubInterfaceSpeedGbps() {
            return this.subInterfaceSpeedGbps;
        }

        @Override
        public OFPortDescPropBsnBreakout.Builder setSubInterfaceSpeedGbps(int subInterfaceSpeedGbps) {
            this.subInterfaceSpeedGbps = subInterfaceSpeedGbps;
            this.subInterfaceSpeedGbpsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFPortDescPropBsnBreakout build() {
            int subInterfaceCount = this.subInterfaceCountSet ? this.subInterfaceCount : this.parentMessage.subInterfaceCount;
            int subInterfaceSpeedGbps = this.subInterfaceSpeedGbpsSet ? this.subInterfaceSpeedGbps : this.parentMessage.subInterfaceSpeedGbps;
            return new OFPortDescPropBsnBreakoutVer14(subInterfaceCount, subInterfaceSpeedGbps);
        }
    }
}

