/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmIpEcn;
import org.projectfloodlight.openflow.types.IpEcn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmIpEcnVer14
implements OFOxmIpEcn {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmIpEcnVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 5;
    private static final IpEcn DEFAULT_VALUE = IpEcn.NONE;
    private final IpEcn value;
    static final OFOxmIpEcnVer14 DEFAULT = new OFOxmIpEcnVer14(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmIpEcnVer14Funnel FUNNEL = new OFOxmIpEcnVer14Funnel();
    static final Writer WRITER = new Writer();

    OFOxmIpEcnVer14(IpEcn value) {
        if (value == null) {
            throw new NullPointerException("OFOxmIpEcnVer14: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 2147488257L;
    }

    @Override
    public IpEcn getValue() {
        return this.value;
    }

    @Override
    public MatchField<IpEcn> getMatchField() {
        return MatchField.IP_ECN;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<IpEcn> getCanonical() {
        return this;
    }

    @Override
    public IpEcn getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.4");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFOxmIpEcn.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmIpEcnVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmIpEcnVer14 other = (OFOxmIpEcnVer14)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmIpEcnVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmIpEcnVer14 message) {
            bb.writeInt(-2147479039);
            message.value.writeByte(bb);
        }
    }

    static class OFOxmIpEcnVer14Funnel
    implements Funnel<OFOxmIpEcnVer14> {
        private static final long serialVersionUID = 1L;

        OFOxmIpEcnVer14Funnel() {
        }

        public void funnel(OFOxmIpEcnVer14 message, PrimitiveSink sink) {
            sink.putInt(-2147479039);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmIpEcn> {
        Reader() {
        }

        @Override
        public OFOxmIpEcn readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -2147479039) {
                throw new OFParseError("Wrong typeLen: Expected=0x80001201L(0x80001201L), got=" + typeLen);
            }
            IpEcn value = IpEcn.readByte(bb);
            OFOxmIpEcnVer14 oxmIpEcnVer14 = new OFOxmIpEcnVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmIpEcnVer14);
            }
            return oxmIpEcnVer14;
        }
    }

    static class Builder
    implements OFOxmIpEcn.Builder {
        private boolean valueSet;
        private IpEcn value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 2147488257L;
        }

        @Override
        public IpEcn getValue() {
            return this.value;
        }

        @Override
        public OFOxmIpEcn.Builder setValue(IpEcn value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<IpEcn> getMatchField() {
            return MatchField.IP_ECN;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<IpEcn> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public IpEcn getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmIpEcn build() {
            IpEcn value;
            IpEcn ipEcn = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmIpEcnVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmIpEcn.Builder {
        final OFOxmIpEcnVer14 parentMessage;
        private boolean valueSet;
        private IpEcn value;

        BuilderWithParent(OFOxmIpEcnVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 2147488257L;
        }

        @Override
        public IpEcn getValue() {
            return this.value;
        }

        @Override
        public OFOxmIpEcn.Builder setValue(IpEcn value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<IpEcn> getMatchField() {
            return MatchField.IP_ECN;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<IpEcn> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public IpEcn getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmIpEcn build() {
            IpEcn value;
            IpEcn ipEcn = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmIpEcnVer14(value);
        }
    }
}

