/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmIcmpv6Type;
import org.projectfloodlight.openflow.types.U8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmIcmpv6TypeVer14
implements OFOxmIcmpv6Type {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmIcmpv6TypeVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 5;
    private static final U8 DEFAULT_VALUE = U8.ZERO;
    private final U8 value;
    static final OFOxmIcmpv6TypeVer14 DEFAULT = new OFOxmIcmpv6TypeVer14(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmIcmpv6TypeVer14Funnel FUNNEL = new OFOxmIcmpv6TypeVer14Funnel();
    static final Writer WRITER = new Writer();

    OFOxmIcmpv6TypeVer14(U8 value) {
        if (value == null) {
            throw new NullPointerException("OFOxmIcmpv6TypeVer14: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 2147498497L;
    }

    @Override
    public U8 getValue() {
        return this.value;
    }

    @Override
    public MatchField<U8> getMatchField() {
        return MatchField.ICMPV6_TYPE;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<U8> getCanonical() {
        return this;
    }

    @Override
    public U8 getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.4");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFOxmIcmpv6Type.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmIcmpv6TypeVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmIcmpv6TypeVer14 other = (OFOxmIcmpv6TypeVer14)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmIcmpv6TypeVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmIcmpv6TypeVer14 message) {
            bb.writeInt(-2147468799);
            bb.writeByte((int)message.value.getRaw());
        }
    }

    static class OFOxmIcmpv6TypeVer14Funnel
    implements Funnel<OFOxmIcmpv6TypeVer14> {
        private static final long serialVersionUID = 1L;

        OFOxmIcmpv6TypeVer14Funnel() {
        }

        public void funnel(OFOxmIcmpv6TypeVer14 message, PrimitiveSink sink) {
            sink.putInt(-2147468799);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmIcmpv6Type> {
        Reader() {
        }

        @Override
        public OFOxmIcmpv6Type readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -2147468799) {
                throw new OFParseError("Wrong typeLen: Expected=0x80003a01L(0x80003a01L), got=" + typeLen);
            }
            U8 value = U8.of(bb.readByte());
            OFOxmIcmpv6TypeVer14 oxmIcmpv6TypeVer14 = new OFOxmIcmpv6TypeVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmIcmpv6TypeVer14);
            }
            return oxmIcmpv6TypeVer14;
        }
    }

    static class Builder
    implements OFOxmIcmpv6Type.Builder {
        private boolean valueSet;
        private U8 value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 2147498497L;
        }

        @Override
        public U8 getValue() {
            return this.value;
        }

        @Override
        public OFOxmIcmpv6Type.Builder setValue(U8 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U8> getMatchField() {
            return MatchField.ICMPV6_TYPE;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U8> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public U8 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmIcmpv6Type build() {
            U8 value;
            U8 u8 = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmIcmpv6TypeVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmIcmpv6Type.Builder {
        final OFOxmIcmpv6TypeVer14 parentMessage;
        private boolean valueSet;
        private U8 value;

        BuilderWithParent(OFOxmIcmpv6TypeVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 2147498497L;
        }

        @Override
        public U8 getValue() {
            return this.value;
        }

        @Override
        public OFOxmIcmpv6Type.Builder setValue(U8 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U8> getMatchField() {
            return MatchField.ICMPV6_TYPE;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U8> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public U8 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmIcmpv6Type build() {
            U8 value;
            U8 u8 = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmIcmpv6TypeVer14(value);
        }
    }
}

