/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFMeterFeatures;
import org.projectfloodlight.openflow.protocol.OFMeterFeaturesStatsReply;
import org.projectfloodlight.openflow.protocol.OFStatsReplyFlags;
import org.projectfloodlight.openflow.protocol.OFStatsType;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver14.OFMeterFeaturesVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFStatsReplyFlagsSerializerVer14;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFMeterFeaturesStatsReplyVer14
implements OFMeterFeaturesStatsReply {
    private static final Logger logger = LoggerFactory.getLogger(OFMeterFeaturesStatsReplyVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 32;
    private static final long DEFAULT_XID = 0L;
    private static final Set<OFStatsReplyFlags> DEFAULT_FLAGS = ImmutableSet.of();
    private final long xid;
    private final Set<OFStatsReplyFlags> flags;
    private final OFMeterFeatures features;
    static final Reader READER = new Reader();
    static final OFMeterFeaturesStatsReplyVer14Funnel FUNNEL = new OFMeterFeaturesStatsReplyVer14Funnel();
    static final Writer WRITER = new Writer();

    OFMeterFeaturesStatsReplyVer14(long xid, Set<OFStatsReplyFlags> flags, OFMeterFeatures features) {
        if (flags == null) {
            throw new NullPointerException("OFMeterFeaturesStatsReplyVer14: property flags cannot be null");
        }
        if (features == null) {
            throw new NullPointerException("OFMeterFeaturesStatsReplyVer14: property features cannot be null");
        }
        this.xid = U32.normalize(xid);
        this.flags = flags;
        this.features = features;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFType getType() {
        return OFType.STATS_REPLY;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFStatsType getStatsType() {
        return OFStatsType.METER_FEATURES;
    }

    @Override
    public Set<OFStatsReplyFlags> getFlags() {
        return this.flags;
    }

    @Override
    public OFMeterFeatures getFeatures() {
        return this.features;
    }

    @Override
    public OFMeterFeaturesStatsReply.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFMeterFeaturesStatsReplyVer14(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("flags=").append(this.flags);
        b.append(", ");
        b.append("features=").append(this.features);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFMeterFeaturesStatsReplyVer14 other = (OFMeterFeaturesStatsReplyVer14)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        return !(this.features == null ? other.features != null : !this.features.equals(other.features));
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFMeterFeaturesStatsReplyVer14 other = (OFMeterFeaturesStatsReplyVer14)obj;
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        return !(this.features == null ? other.features != null : !this.features.equals(other.features));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + (this.features == null ? 0 : this.features.hashCode());
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + (this.features == null ? 0 : this.features.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFMeterFeaturesStatsReplyVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFMeterFeaturesStatsReplyVer14 message) {
            bb.writeByte(5);
            bb.writeByte(19);
            bb.writeShort(32);
            bb.writeInt(U32.t(message.xid));
            bb.writeShort(11);
            OFStatsReplyFlagsSerializerVer14.writeTo(bb, message.flags);
            bb.writeZero(4);
            message.features.writeTo(bb);
        }
    }

    static class OFMeterFeaturesStatsReplyVer14Funnel
    implements Funnel<OFMeterFeaturesStatsReplyVer14> {
        private static final long serialVersionUID = 1L;

        OFMeterFeaturesStatsReplyVer14Funnel() {
        }

        public void funnel(OFMeterFeaturesStatsReplyVer14 message, PrimitiveSink sink) {
            sink.putByte((byte)5);
            sink.putByte((byte)19);
            sink.putShort((short)32);
            sink.putLong(message.xid);
            sink.putShort((short)11);
            OFStatsReplyFlagsSerializerVer14.putTo(message.flags, sink);
            message.features.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFMeterFeaturesStatsReply> {
        Reader() {
        }

        @Override
        public OFMeterFeaturesStatsReply readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 5) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_14(5), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 19) {
                throw new OFParseError("Wrong type: Expected=OFType.STATS_REPLY(19), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 32) {
                throw new OFParseError("Wrong length: Expected=32(32), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            short statsType = bb.readShort();
            if (statsType != 11) {
                throw new OFParseError("Wrong statsType: Expected=OFStatsType.METER_FEATURES(11), got=" + statsType);
            }
            Set<OFStatsReplyFlags> flags = OFStatsReplyFlagsSerializerVer14.readFrom(bb);
            bb.skipBytes(4);
            OFMeterFeatures features = OFMeterFeaturesVer14.READER.readFrom(bb);
            OFMeterFeaturesStatsReplyVer14 meterFeaturesStatsReplyVer14 = new OFMeterFeaturesStatsReplyVer14(xid, flags, features);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)meterFeaturesStatsReplyVer14);
            }
            return meterFeaturesStatsReplyVer14;
        }
    }

    static class Builder
    implements OFMeterFeaturesStatsReply.Builder {
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsReplyFlags> flags;
        private boolean featuresSet;
        private OFMeterFeatures features;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REPLY;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFMeterFeaturesStatsReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.METER_FEATURES;
        }

        @Override
        public Set<OFStatsReplyFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFMeterFeaturesStatsReply.Builder setFlags(Set<OFStatsReplyFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public OFMeterFeatures getFeatures() {
            return this.features;
        }

        @Override
        public OFMeterFeaturesStatsReply.Builder setFeatures(OFMeterFeatures features) {
            this.features = features;
            this.featuresSet = true;
            return this;
        }

        @Override
        public OFMeterFeaturesStatsReply build() {
            Set<OFStatsReplyFlags> flags;
            long xid = this.xidSet ? this.xid : 0L;
            Set<OFStatsReplyFlags> set = flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            if (!this.featuresSet) {
                throw new IllegalStateException("Property features doesn't have default value -- must be set");
            }
            if (this.features == null) {
                throw new NullPointerException("Property features must not be null");
            }
            return new OFMeterFeaturesStatsReplyVer14(xid, flags, this.features);
        }
    }

    static class BuilderWithParent
    implements OFMeterFeaturesStatsReply.Builder {
        final OFMeterFeaturesStatsReplyVer14 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsReplyFlags> flags;
        private boolean featuresSet;
        private OFMeterFeatures features;

        BuilderWithParent(OFMeterFeaturesStatsReplyVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REPLY;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFMeterFeaturesStatsReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.METER_FEATURES;
        }

        @Override
        public Set<OFStatsReplyFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFMeterFeaturesStatsReply.Builder setFlags(Set<OFStatsReplyFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public OFMeterFeatures getFeatures() {
            return this.features;
        }

        @Override
        public OFMeterFeaturesStatsReply.Builder setFeatures(OFMeterFeatures features) {
            this.features = features;
            this.featuresSet = true;
            return this;
        }

        @Override
        public OFMeterFeaturesStatsReply build() {
            OFMeterFeatures features;
            Set flags;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            Set set = flags = this.flagsSet ? this.flags : this.parentMessage.flags;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            OFMeterFeatures oFMeterFeatures = features = this.featuresSet ? this.features : this.parentMessage.features;
            if (features == null) {
                throw new NullPointerException("Property features must not be null");
            }
            return new OFMeterFeaturesStatsReplyVer14(xid, flags, features);
        }
    }
}

