/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvTcpSrc;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvTcpSrcVer14
implements OFBsnTlvTcpSrc {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvTcpSrcVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 6;
    private static final int DEFAULT_VALUE = 0;
    private final int value;
    static final OFBsnTlvTcpSrcVer14 DEFAULT = new OFBsnTlvTcpSrcVer14(0);
    static final Reader READER = new Reader();
    static final OFBsnTlvTcpSrcVer14Funnel FUNNEL = new OFBsnTlvTcpSrcVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvTcpSrcVer14(int value) {
        this.value = U16.normalize(value);
    }

    @Override
    public int getType() {
        return 65;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTlvTcpSrc.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvTcpSrcVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvTcpSrcVer14 other = (OFBsnTlvTcpSrcVer14)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.value;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvTcpSrcVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvTcpSrcVer14 message) {
            bb.writeShort(65);
            bb.writeShort(6);
            bb.writeShort((int)U16.t(message.value));
        }
    }

    static class OFBsnTlvTcpSrcVer14Funnel
    implements Funnel<OFBsnTlvTcpSrcVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvTcpSrcVer14Funnel() {
        }

        public void funnel(OFBsnTlvTcpSrcVer14 message, PrimitiveSink sink) {
            sink.putShort((short)65);
            sink.putShort((short)6);
            sink.putInt(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvTcpSrc> {
        Reader() {
        }

        @Override
        public OFBsnTlvTcpSrc readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 65) {
                throw new OFParseError("Wrong type: Expected=0x41(0x41), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 6) {
                throw new OFParseError("Wrong length: Expected=6(6), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            int value = U16.f(bb.readShort());
            OFBsnTlvTcpSrcVer14 bsnTlvTcpSrcVer14 = new OFBsnTlvTcpSrcVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvTcpSrcVer14);
            }
            return bsnTlvTcpSrcVer14;
        }
    }

    static class Builder
    implements OFBsnTlvTcpSrc.Builder {
        private boolean valueSet;
        private int value;

        Builder() {
        }

        @Override
        public int getType() {
            return 65;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvTcpSrc.Builder setValue(int value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvTcpSrc build() {
            int value = this.valueSet ? this.value : 0;
            return new OFBsnTlvTcpSrcVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvTcpSrc.Builder {
        final OFBsnTlvTcpSrcVer14 parentMessage;
        private boolean valueSet;
        private int value;

        BuilderWithParent(OFBsnTlvTcpSrcVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 65;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvTcpSrc.Builder setValue(int value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvTcpSrc build() {
            int value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvTcpSrcVer14(value);
        }
    }
}

