/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvRequestPackets;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvRequestPacketsVer14
implements OFBsnTlvRequestPackets {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvRequestPacketsVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 12;
    private static final U64 DEFAULT_VALUE = U64.ZERO;
    private final U64 value;
    static final OFBsnTlvRequestPacketsVer14 DEFAULT = new OFBsnTlvRequestPacketsVer14(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFBsnTlvRequestPacketsVer14Funnel FUNNEL = new OFBsnTlvRequestPacketsVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvRequestPacketsVer14(U64 value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvRequestPacketsVer14: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 11;
    }

    @Override
    public U64 getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTlvRequestPackets.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvRequestPacketsVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvRequestPacketsVer14 other = (OFBsnTlvRequestPacketsVer14)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvRequestPacketsVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvRequestPacketsVer14 message) {
            bb.writeShort(11);
            bb.writeShort(12);
            bb.writeLong(message.value.getValue());
        }
    }

    static class OFBsnTlvRequestPacketsVer14Funnel
    implements Funnel<OFBsnTlvRequestPacketsVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvRequestPacketsVer14Funnel() {
        }

        public void funnel(OFBsnTlvRequestPacketsVer14 message, PrimitiveSink sink) {
            sink.putShort((short)11);
            sink.putShort((short)12);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvRequestPackets> {
        Reader() {
        }

        @Override
        public OFBsnTlvRequestPackets readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 11) {
                throw new OFParseError("Wrong type: Expected=0xb(0xb), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 12) {
                throw new OFParseError("Wrong length: Expected=12(12), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            U64 value = U64.ofRaw(bb.readLong());
            OFBsnTlvRequestPacketsVer14 bsnTlvRequestPacketsVer14 = new OFBsnTlvRequestPacketsVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvRequestPacketsVer14);
            }
            return bsnTlvRequestPacketsVer14;
        }
    }

    static class Builder
    implements OFBsnTlvRequestPackets.Builder {
        private boolean valueSet;
        private U64 value;

        Builder() {
        }

        @Override
        public int getType() {
            return 11;
        }

        @Override
        public U64 getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvRequestPackets.Builder setValue(U64 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvRequestPackets build() {
            U64 value;
            U64 u64 = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvRequestPacketsVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvRequestPackets.Builder {
        final OFBsnTlvRequestPacketsVer14 parentMessage;
        private boolean valueSet;
        private U64 value;

        BuilderWithParent(OFBsnTlvRequestPacketsVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 11;
        }

        @Override
        public U64 getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvRequestPackets.Builder setValue(U64 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvRequestPackets build() {
            U64 value;
            U64 u64 = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvRequestPacketsVer14(value);
        }
    }
}

