/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvLoad;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvLoadVer14
implements OFBsnTlvLoad {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvLoadVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 8;
    private static final long DEFAULT_VALUE = 0L;
    private final long value;
    static final OFBsnTlvLoadVer14 DEFAULT = new OFBsnTlvLoadVer14(0L);
    static final Reader READER = new Reader();
    static final OFBsnTlvLoadVer14Funnel FUNNEL = new OFBsnTlvLoadVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvLoadVer14(long value) {
        this.value = U32.normalize(value);
    }

    @Override
    public int getType() {
        return 213;
    }

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTlvLoad.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvLoadVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvLoadVer14 other = (OFBsnTlvLoadVer14)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.value ^ this.value >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvLoadVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvLoadVer14 message) {
            bb.writeShort(213);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.value));
        }
    }

    static class OFBsnTlvLoadVer14Funnel
    implements Funnel<OFBsnTlvLoadVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvLoadVer14Funnel() {
        }

        public void funnel(OFBsnTlvLoadVer14 message, PrimitiveSink sink) {
            sink.putShort((short)213);
            sink.putShort((short)8);
            sink.putLong(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvLoad> {
        Reader() {
        }

        @Override
        public OFBsnTlvLoad readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 213) {
                throw new OFParseError("Wrong type: Expected=0xd5(0xd5), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long value = U32.f(bb.readInt());
            OFBsnTlvLoadVer14 bsnTlvLoadVer14 = new OFBsnTlvLoadVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvLoadVer14);
            }
            return bsnTlvLoadVer14;
        }
    }

    static class Builder
    implements OFBsnTlvLoad.Builder {
        private boolean valueSet;
        private long value;

        Builder() {
        }

        @Override
        public int getType() {
            return 213;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvLoad.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvLoad build() {
            long value = this.valueSet ? this.value : 0L;
            return new OFBsnTlvLoadVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvLoad.Builder {
        final OFBsnTlvLoadVer14 parentMessage;
        private boolean valueSet;
        private long value;

        BuilderWithParent(OFBsnTlvLoadVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 213;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvLoad.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvLoad build() {
            long value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvLoadVer14(value);
        }
    }
}

