/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvIpv6Dst;
import org.projectfloodlight.openflow.types.IPv6Address;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvIpv6DstVer14
implements OFBsnTlvIpv6Dst {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvIpv6DstVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 20;
    private static final IPv6Address DEFAULT_VALUE = IPv6Address.NONE;
    private final IPv6Address value;
    static final OFBsnTlvIpv6DstVer14 DEFAULT = new OFBsnTlvIpv6DstVer14(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFBsnTlvIpv6DstVer14Funnel FUNNEL = new OFBsnTlvIpv6DstVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvIpv6DstVer14(IPv6Address value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvIpv6DstVer14: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 127;
    }

    @Override
    public IPv6Address getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTlvIpv6Dst.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvIpv6DstVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvIpv6DstVer14 other = (OFBsnTlvIpv6DstVer14)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvIpv6DstVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvIpv6DstVer14 message) {
            bb.writeShort(127);
            bb.writeShort(20);
            message.value.write16Bytes(bb);
        }
    }

    static class OFBsnTlvIpv6DstVer14Funnel
    implements Funnel<OFBsnTlvIpv6DstVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvIpv6DstVer14Funnel() {
        }

        public void funnel(OFBsnTlvIpv6DstVer14 message, PrimitiveSink sink) {
            sink.putShort((short)127);
            sink.putShort((short)20);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvIpv6Dst> {
        Reader() {
        }

        @Override
        public OFBsnTlvIpv6Dst readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 127) {
                throw new OFParseError("Wrong type: Expected=0x7f(0x7f), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 20) {
                throw new OFParseError("Wrong length: Expected=20(20), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            IPv6Address value = IPv6Address.read16Bytes(bb);
            OFBsnTlvIpv6DstVer14 bsnTlvIpv6DstVer14 = new OFBsnTlvIpv6DstVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvIpv6DstVer14);
            }
            return bsnTlvIpv6DstVer14;
        }
    }

    static class Builder
    implements OFBsnTlvIpv6Dst.Builder {
        private boolean valueSet;
        private IPv6Address value;

        Builder() {
        }

        @Override
        public int getType() {
            return 127;
        }

        @Override
        public IPv6Address getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvIpv6Dst.Builder setValue(IPv6Address value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvIpv6Dst build() {
            IPv6Address value;
            IPv6Address iPv6Address = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvIpv6DstVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvIpv6Dst.Builder {
        final OFBsnTlvIpv6DstVer14 parentMessage;
        private boolean valueSet;
        private IPv6Address value;

        BuilderWithParent(OFBsnTlvIpv6DstVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 127;
        }

        @Override
        public IPv6Address getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvIpv6Dst.Builder setValue(IPv6Address value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvIpv6Dst build() {
            IPv6Address value;
            IPv6Address iPv6Address = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvIpv6DstVer14(value);
        }
    }
}

