/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnIpTunnelType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvIpTunnelType;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnIpTunnelTypeSerializerVer14;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvIpTunnelTypeVer14
implements OFBsnTlvIpTunnelType {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvIpTunnelTypeVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 6;
    private final OFBsnIpTunnelType value;
    static final Reader READER = new Reader();
    static final OFBsnTlvIpTunnelTypeVer14Funnel FUNNEL = new OFBsnTlvIpTunnelTypeVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvIpTunnelTypeVer14(OFBsnIpTunnelType value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvIpTunnelTypeVer14: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 169;
    }

    @Override
    public OFBsnIpTunnelType getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTlvIpTunnelType.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvIpTunnelTypeVer14(");
        b.append("value=").append((Object)this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvIpTunnelTypeVer14 other = (OFBsnTlvIpTunnelTypeVer14)obj;
        return !(this.value == null ? other.value != null : !this.value.equals((Object)other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvIpTunnelTypeVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvIpTunnelTypeVer14 message) {
            bb.writeShort(169);
            bb.writeShort(6);
            OFBsnIpTunnelTypeSerializerVer14.writeTo(bb, message.value);
        }
    }

    static class OFBsnTlvIpTunnelTypeVer14Funnel
    implements Funnel<OFBsnTlvIpTunnelTypeVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvIpTunnelTypeVer14Funnel() {
        }

        public void funnel(OFBsnTlvIpTunnelTypeVer14 message, PrimitiveSink sink) {
            sink.putShort((short)169);
            sink.putShort((short)6);
            OFBsnIpTunnelTypeSerializerVer14.putTo(message.value, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvIpTunnelType> {
        Reader() {
        }

        @Override
        public OFBsnTlvIpTunnelType readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 169) {
                throw new OFParseError("Wrong type: Expected=0xa9(0xa9), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 6) {
                throw new OFParseError("Wrong length: Expected=6(6), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFBsnIpTunnelType value = OFBsnIpTunnelTypeSerializerVer14.readFrom(bb);
            OFBsnTlvIpTunnelTypeVer14 bsnTlvIpTunnelTypeVer14 = new OFBsnTlvIpTunnelTypeVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvIpTunnelTypeVer14);
            }
            return bsnTlvIpTunnelTypeVer14;
        }
    }

    static class Builder
    implements OFBsnTlvIpTunnelType.Builder {
        private boolean valueSet;
        private OFBsnIpTunnelType value;

        Builder() {
        }

        @Override
        public int getType() {
            return 169;
        }

        @Override
        public OFBsnIpTunnelType getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvIpTunnelType.Builder setValue(OFBsnIpTunnelType value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvIpTunnelType build() {
            if (!this.valueSet) {
                throw new IllegalStateException("Property value doesn't have default value -- must be set");
            }
            if (this.value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvIpTunnelTypeVer14(this.value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvIpTunnelType.Builder {
        final OFBsnTlvIpTunnelTypeVer14 parentMessage;
        private boolean valueSet;
        private OFBsnIpTunnelType value;

        BuilderWithParent(OFBsnTlvIpTunnelTypeVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 169;
        }

        @Override
        public OFBsnIpTunnelType getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvIpTunnelType.Builder setValue(OFBsnIpTunnelType value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvIpTunnelType build() {
            OFBsnIpTunnelType value;
            OFBsnIpTunnelType oFBsnIpTunnelType = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvIpTunnelTypeVer14(value);
        }
    }
}

