/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnIpFragmentation;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvIpFragmentation;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnIpFragmentationSerializerVer14;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvIpFragmentationVer14
implements OFBsnTlvIpFragmentation {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvIpFragmentationVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 5;
    private final OFBsnIpFragmentation value;
    static final Reader READER = new Reader();
    static final OFBsnTlvIpFragmentationVer14Funnel FUNNEL = new OFBsnTlvIpFragmentationVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvIpFragmentationVer14(OFBsnIpFragmentation value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvIpFragmentationVer14: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 201;
    }

    @Override
    public OFBsnIpFragmentation getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTlvIpFragmentation.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvIpFragmentationVer14(");
        b.append("value=").append((Object)this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvIpFragmentationVer14 other = (OFBsnTlvIpFragmentationVer14)obj;
        return !(this.value == null ? other.value != null : !this.value.equals((Object)other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvIpFragmentationVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvIpFragmentationVer14 message) {
            bb.writeShort(201);
            bb.writeShort(5);
            OFBsnIpFragmentationSerializerVer14.writeTo(bb, message.value);
        }
    }

    static class OFBsnTlvIpFragmentationVer14Funnel
    implements Funnel<OFBsnTlvIpFragmentationVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvIpFragmentationVer14Funnel() {
        }

        public void funnel(OFBsnTlvIpFragmentationVer14 message, PrimitiveSink sink) {
            sink.putShort((short)201);
            sink.putShort((short)5);
            OFBsnIpFragmentationSerializerVer14.putTo(message.value, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvIpFragmentation> {
        Reader() {
        }

        @Override
        public OFBsnTlvIpFragmentation readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 201) {
                throw new OFParseError("Wrong type: Expected=0xc9(0xc9), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 5) {
                throw new OFParseError("Wrong length: Expected=5(5), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFBsnIpFragmentation value = OFBsnIpFragmentationSerializerVer14.readFrom(bb);
            OFBsnTlvIpFragmentationVer14 bsnTlvIpFragmentationVer14 = new OFBsnTlvIpFragmentationVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvIpFragmentationVer14);
            }
            return bsnTlvIpFragmentationVer14;
        }
    }

    static class Builder
    implements OFBsnTlvIpFragmentation.Builder {
        private boolean valueSet;
        private OFBsnIpFragmentation value;

        Builder() {
        }

        @Override
        public int getType() {
            return 201;
        }

        @Override
        public OFBsnIpFragmentation getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvIpFragmentation.Builder setValue(OFBsnIpFragmentation value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvIpFragmentation build() {
            if (!this.valueSet) {
                throw new IllegalStateException("Property value doesn't have default value -- must be set");
            }
            if (this.value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvIpFragmentationVer14(this.value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvIpFragmentation.Builder {
        final OFBsnTlvIpFragmentationVer14 parentMessage;
        private boolean valueSet;
        private OFBsnIpFragmentation value;

        BuilderWithParent(OFBsnTlvIpFragmentationVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 201;
        }

        @Override
        public OFBsnIpFragmentation getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvIpFragmentation.Builder setValue(OFBsnIpFragmentation value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvIpFragmentation build() {
            OFBsnIpFragmentation value;
            OFBsnIpFragmentation oFBsnIpFragmentation = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvIpFragmentationVer14(value);
        }
    }
}

