/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvExternalMac;
import org.projectfloodlight.openflow.types.MacAddress;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvExternalMacVer14
implements OFBsnTlvExternalMac {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvExternalMacVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 10;
    private static final MacAddress DEFAULT_VALUE = MacAddress.NONE;
    private final MacAddress value;
    static final OFBsnTlvExternalMacVer14 DEFAULT = new OFBsnTlvExternalMacVer14(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFBsnTlvExternalMacVer14Funnel FUNNEL = new OFBsnTlvExternalMacVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvExternalMacVer14(MacAddress value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvExternalMacVer14: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 24;
    }

    @Override
    public MacAddress getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTlvExternalMac.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvExternalMacVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvExternalMacVer14 other = (OFBsnTlvExternalMacVer14)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvExternalMacVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvExternalMacVer14 message) {
            bb.writeShort(24);
            bb.writeShort(10);
            message.value.write6Bytes(bb);
        }
    }

    static class OFBsnTlvExternalMacVer14Funnel
    implements Funnel<OFBsnTlvExternalMacVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvExternalMacVer14Funnel() {
        }

        public void funnel(OFBsnTlvExternalMacVer14 message, PrimitiveSink sink) {
            sink.putShort((short)24);
            sink.putShort((short)10);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvExternalMac> {
        Reader() {
        }

        @Override
        public OFBsnTlvExternalMac readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 24) {
                throw new OFParseError("Wrong type: Expected=0x18(0x18), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 10) {
                throw new OFParseError("Wrong length: Expected=10(10), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            MacAddress value = MacAddress.read6Bytes(bb);
            OFBsnTlvExternalMacVer14 bsnTlvExternalMacVer14 = new OFBsnTlvExternalMacVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvExternalMacVer14);
            }
            return bsnTlvExternalMacVer14;
        }
    }

    static class Builder
    implements OFBsnTlvExternalMac.Builder {
        private boolean valueSet;
        private MacAddress value;

        Builder() {
        }

        @Override
        public int getType() {
            return 24;
        }

        @Override
        public MacAddress getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvExternalMac.Builder setValue(MacAddress value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvExternalMac build() {
            MacAddress value;
            MacAddress macAddress = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvExternalMacVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvExternalMac.Builder {
        final OFBsnTlvExternalMacVer14 parentMessage;
        private boolean valueSet;
        private MacAddress value;

        BuilderWithParent(OFBsnTlvExternalMacVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 24;
        }

        @Override
        public MacAddress getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvExternalMac.Builder setValue(MacAddress value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvExternalMac build() {
            MacAddress value;
            MacAddress macAddress = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvExternalMacVer14(value);
        }
    }
}

