/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvDscp;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvDscpVer14
implements OFBsnTlvDscp {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvDscpVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 6;
    private static final int DEFAULT_VALUE = 0;
    private final int value;
    static final OFBsnTlvDscpVer14 DEFAULT = new OFBsnTlvDscpVer14(0);
    static final Reader READER = new Reader();
    static final OFBsnTlvDscpVer14Funnel FUNNEL = new OFBsnTlvDscpVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvDscpVer14(int value) {
        this.value = U16.normalize(value);
    }

    @Override
    public int getType() {
        return 112;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTlvDscp.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvDscpVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvDscpVer14 other = (OFBsnTlvDscpVer14)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.value;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvDscpVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvDscpVer14 message) {
            bb.writeShort(112);
            bb.writeShort(6);
            bb.writeShort((int)U16.t(message.value));
        }
    }

    static class OFBsnTlvDscpVer14Funnel
    implements Funnel<OFBsnTlvDscpVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvDscpVer14Funnel() {
        }

        public void funnel(OFBsnTlvDscpVer14 message, PrimitiveSink sink) {
            sink.putShort((short)112);
            sink.putShort((short)6);
            sink.putInt(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvDscp> {
        Reader() {
        }

        @Override
        public OFBsnTlvDscp readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 112) {
                throw new OFParseError("Wrong type: Expected=0x70(0x70), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 6) {
                throw new OFParseError("Wrong length: Expected=6(6), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            int value = U16.f(bb.readShort());
            OFBsnTlvDscpVer14 bsnTlvDscpVer14 = new OFBsnTlvDscpVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvDscpVer14);
            }
            return bsnTlvDscpVer14;
        }
    }

    static class Builder
    implements OFBsnTlvDscp.Builder {
        private boolean valueSet;
        private int value;

        Builder() {
        }

        @Override
        public int getType() {
            return 112;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvDscp.Builder setValue(int value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvDscp build() {
            int value = this.valueSet ? this.value : 0;
            return new OFBsnTlvDscpVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvDscp.Builder {
        final OFBsnTlvDscpVer14 parentMessage;
        private boolean valueSet;
        private int value;

        BuilderWithParent(OFBsnTlvDscpVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 112;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvDscp.Builder setValue(int value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvDscp build() {
            int value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvDscpVer14(value);
        }
    }
}

