/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvBroadcastRate;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvBroadcastRateVer14
implements OFBsnTlvBroadcastRate {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvBroadcastRateVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 8;
    private static final long DEFAULT_VALUE = 0L;
    private final long value;
    static final OFBsnTlvBroadcastRateVer14 DEFAULT = new OFBsnTlvBroadcastRateVer14(0L);
    static final Reader READER = new Reader();
    static final OFBsnTlvBroadcastRateVer14Funnel FUNNEL = new OFBsnTlvBroadcastRateVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvBroadcastRateVer14(long value) {
        this.value = U32.normalize(value);
    }

    @Override
    public int getType() {
        return 90;
    }

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTlvBroadcastRate.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvBroadcastRateVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvBroadcastRateVer14 other = (OFBsnTlvBroadcastRateVer14)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.value ^ this.value >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvBroadcastRateVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvBroadcastRateVer14 message) {
            bb.writeShort(90);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.value));
        }
    }

    static class OFBsnTlvBroadcastRateVer14Funnel
    implements Funnel<OFBsnTlvBroadcastRateVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvBroadcastRateVer14Funnel() {
        }

        public void funnel(OFBsnTlvBroadcastRateVer14 message, PrimitiveSink sink) {
            sink.putShort((short)90);
            sink.putShort((short)8);
            sink.putLong(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvBroadcastRate> {
        Reader() {
        }

        @Override
        public OFBsnTlvBroadcastRate readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 90) {
                throw new OFParseError("Wrong type: Expected=0x5a(0x5a), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long value = U32.f(bb.readInt());
            OFBsnTlvBroadcastRateVer14 bsnTlvBroadcastRateVer14 = new OFBsnTlvBroadcastRateVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvBroadcastRateVer14);
            }
            return bsnTlvBroadcastRateVer14;
        }
    }

    static class Builder
    implements OFBsnTlvBroadcastRate.Builder {
        private boolean valueSet;
        private long value;

        Builder() {
        }

        @Override
        public int getType() {
            return 90;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvBroadcastRate.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvBroadcastRate build() {
            long value = this.valueSet ? this.value : 0L;
            return new OFBsnTlvBroadcastRateVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvBroadcastRate.Builder {
        final OFBsnTlvBroadcastRateVer14 parentMessage;
        private boolean valueSet;
        private long value;

        BuilderWithParent(OFBsnTlvBroadcastRateVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 90;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvBroadcastRate.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvBroadcastRate build() {
            long value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvBroadcastRateVer14(value);
        }
    }
}

