/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnHeader;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnArpIdleVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnBwClearDataReplyVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnBwClearDataRequestVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnBwEnableGetReplyVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnBwEnableGetRequestVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnBwEnableSetReplyVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnBwEnableSetRequestVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnControllerConnectionsReplyVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnControllerConnectionsRequestVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnFlowIdleEnableGetReplyVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnFlowIdleEnableGetRequestVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnFlowIdleEnableSetReplyVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnFlowIdleEnableSetRequestVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnFlowIdleVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnGenericAsyncVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnGenericCommandReplyVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnGenericCommandVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnGentableClearReplyVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnGentableClearRequestVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnGentableEntryAddVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnGentableEntryDeleteVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnGentableSetBucketsSizeVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnGetInterfacesReplyVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnGetInterfacesRequestVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnGetMirroringReplyVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnGetMirroringRequestVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnGetSwitchPipelineReplyVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnGetSwitchPipelineRequestVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnLacpConvergenceNotifVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnLogVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnLuaCommandReplyVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnLuaCommandRequestVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnLuaNotificationVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnLuaUploadVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnPduRxReplyVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnPduRxRequestVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnPduRxTimeoutVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnPduTxReplyVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnPduTxRequestVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnSetAuxCxnsReplyVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnSetAuxCxnsRequestVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnSetLacpReplyVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnSetLacpRequestVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnSetMirroringVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnSetPktinSuppressionReplyVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnSetPktinSuppressionRequestVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnSetSwitchPipelineReplyVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnSetSwitchPipelineRequestVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnTableSetBucketsSizeVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnTakeoverVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnTimeReplyVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnTimeRequestVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnVirtualPortCreateReplyVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnVirtualPortCreateRequestVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnVirtualPortRemoveReplyVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnVirtualPortRemoveRequestVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnVlanCounterClearVer14;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;

abstract class OFBsnHeaderVer14 {
    static final byte WIRE_VERSION = 5;
    static final int MINIMUM_LENGTH = 16;
    public static final Reader READER = new Reader();

    OFBsnHeaderVer14() {
    }

    static class Reader
    implements OFMessageReader<OFBsnHeader> {
        Reader() {
        }

        @Override
        public OFBsnHeader readFrom(ByteBuf bb) throws OFParseError {
            if (bb.readableBytes() < 16) {
                return null;
            }
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 5) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_14(5), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 16) {
                throw new OFParseError("Wrong length: Expected to be >= 16, was: " + length);
            }
            U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            bb.readerIndex(start);
            switch (subtype) {
                case 22: {
                    return OFBsnBwClearDataReplyVer14.READER.readFrom(bb);
                }
                case 21: {
                    return OFBsnBwClearDataRequestVer14.READER.readFrom(bb);
                }
                case 20: {
                    return OFBsnBwEnableGetReplyVer14.READER.readFrom(bb);
                }
                case 19: {
                    return OFBsnBwEnableGetRequestVer14.READER.readFrom(bb);
                }
                case 23: {
                    return OFBsnBwEnableSetReplyVer14.READER.readFrom(bb);
                }
                case 18: {
                    return OFBsnBwEnableSetRequestVer14.READER.readFrom(bb);
                }
                case 10: {
                    return OFBsnGetInterfacesReplyVer14.READER.readFrom(bb);
                }
                case 9: {
                    return OFBsnGetInterfacesRequestVer14.READER.readFrom(bb);
                }
                case 5: {
                    return OFBsnGetMirroringReplyVer14.READER.readFrom(bb);
                }
                case 4: {
                    return OFBsnGetMirroringRequestVer14.READER.readFrom(bb);
                }
                case 34: {
                    return OFBsnPduRxReplyVer14.READER.readFrom(bb);
                }
                case 33: {
                    return OFBsnPduRxRequestVer14.READER.readFrom(bb);
                }
                case 35: {
                    return OFBsnPduRxTimeoutVer14.READER.readFrom(bb);
                }
                case 32: {
                    return OFBsnPduTxReplyVer14.READER.readFrom(bb);
                }
                case 31: {
                    return OFBsnPduTxRequestVer14.READER.readFrom(bb);
                }
                case 3: {
                    return OFBsnSetMirroringVer14.READER.readFrom(bb);
                }
                case 25: {
                    return OFBsnSetPktinSuppressionReplyVer14.READER.readFrom(bb);
                }
                case 11: {
                    return OFBsnSetPktinSuppressionRequestVer14.READER.readFrom(bb);
                }
                case 16: {
                    return OFBsnVirtualPortCreateReplyVer14.READER.readFrom(bb);
                }
                case 15: {
                    return OFBsnVirtualPortCreateRequestVer14.READER.readFrom(bb);
                }
                case 26: {
                    return OFBsnVirtualPortRemoveReplyVer14.READER.readFrom(bb);
                }
                case 17: {
                    return OFBsnVirtualPortRemoveRequestVer14.READER.readFrom(bb);
                }
                case 60: {
                    return OFBsnArpIdleVer14.READER.readFrom(bb);
                }
                case 57: {
                    return OFBsnControllerConnectionsReplyVer14.READER.readFrom(bb);
                }
                case 56: {
                    return OFBsnControllerConnectionsRequestVer14.READER.readFrom(bb);
                }
                case 40: {
                    return OFBsnFlowIdleVer14.READER.readFrom(bb);
                }
                case 39: {
                    return OFBsnFlowIdleEnableGetReplyVer14.READER.readFrom(bb);
                }
                case 38: {
                    return OFBsnFlowIdleEnableGetRequestVer14.READER.readFrom(bb);
                }
                case 37: {
                    return OFBsnFlowIdleEnableSetReplyVer14.READER.readFrom(bb);
                }
                case 36: {
                    return OFBsnFlowIdleEnableSetRequestVer14.READER.readFrom(bb);
                }
                case 49: {
                    return OFBsnGentableClearReplyVer14.READER.readFrom(bb);
                }
                case 48: {
                    return OFBsnGentableClearRequestVer14.READER.readFrom(bb);
                }
                case 46: {
                    return OFBsnGentableEntryAddVer14.READER.readFrom(bb);
                }
                case 47: {
                    return OFBsnGentableEntryDeleteVer14.READER.readFrom(bb);
                }
                case 50: {
                    return OFBsnGentableSetBucketsSizeVer14.READER.readFrom(bb);
                }
                case 52: {
                    return OFBsnGetSwitchPipelineReplyVer14.READER.readFrom(bb);
                }
                case 51: {
                    return OFBsnGetSwitchPipelineRequestVer14.READER.readFrom(bb);
                }
                case 43: {
                    return OFBsnLacpConvergenceNotifVer14.READER.readFrom(bb);
                }
                case 63: {
                    return OFBsnLogVer14.READER.readFrom(bb);
                }
                case 66: {
                    return OFBsnLuaCommandReplyVer14.READER.readFrom(bb);
                }
                case 65: {
                    return OFBsnLuaCommandRequestVer14.READER.readFrom(bb);
                }
                case 67: {
                    return OFBsnLuaNotificationVer14.READER.readFrom(bb);
                }
                case 64: {
                    return OFBsnLuaUploadVer14.READER.readFrom(bb);
                }
                case 59: {
                    return OFBsnSetAuxCxnsReplyVer14.READER.readFrom(bb);
                }
                case 58: {
                    return OFBsnSetAuxCxnsRequestVer14.READER.readFrom(bb);
                }
                case 42: {
                    return OFBsnSetLacpReplyVer14.READER.readFrom(bb);
                }
                case 41: {
                    return OFBsnSetLacpRequestVer14.READER.readFrom(bb);
                }
                case 54: {
                    return OFBsnSetSwitchPipelineReplyVer14.READER.readFrom(bb);
                }
                case 53: {
                    return OFBsnSetSwitchPipelineRequestVer14.READER.readFrom(bb);
                }
                case 61: {
                    return OFBsnTableSetBucketsSizeVer14.READER.readFrom(bb);
                }
                case 45: {
                    return OFBsnTimeReplyVer14.READER.readFrom(bb);
                }
                case 44: {
                    return OFBsnTimeRequestVer14.READER.readFrom(bb);
                }
                case 70: {
                    return OFBsnVlanCounterClearVer14.READER.readFrom(bb);
                }
                case 68: {
                    return OFBsnGenericAsyncVer14.READER.readFrom(bb);
                }
                case 71: {
                    return OFBsnGenericCommandVer14.READER.readFrom(bb);
                }
                case 72: {
                    return OFBsnGenericCommandReplyVer14.READER.readFrom(bb);
                }
                case 69: {
                    return OFBsnTakeoverVer14.READER.readFrom(bb);
                }
            }
            throw new OFParseError("Unknown value for discriminator subtype of class OFBsnHeaderVer14: " + subtype);
        }
    }
}

