/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnGenericCommandReply;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlv;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnTlvVer14;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnGenericCommandReplyVer14
implements OFBsnGenericCommandReply {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnGenericCommandReplyVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int MINIMUM_LENGTH = 20;
    static final int MAXIMUM_LENGTH = 65535;
    private static final long DEFAULT_XID = 0L;
    private static final long DEFAULT_STATUS = 0L;
    private static final List<OFBsnTlv> DEFAULT_TLVS = ImmutableList.of();
    private final long xid;
    private final long status;
    private final List<OFBsnTlv> tlvs;
    static final OFBsnGenericCommandReplyVer14 DEFAULT = new OFBsnGenericCommandReplyVer14(0L, 0L, DEFAULT_TLVS);
    static final Reader READER = new Reader();
    static final OFBsnGenericCommandReplyVer14Funnel FUNNEL = new OFBsnGenericCommandReplyVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnGenericCommandReplyVer14(long xid, long status, List<OFBsnTlv> tlvs) {
        if (tlvs == null) {
            throw new NullPointerException("OFBsnGenericCommandReplyVer14: property tlvs cannot be null");
        }
        this.xid = U32.normalize(xid);
        this.status = U32.normalize(status);
        this.tlvs = tlvs;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 72L;
    }

    @Override
    public long getStatus() {
        return this.status;
    }

    @Override
    public List<OFBsnTlv> getTlvs() {
        return this.tlvs;
    }

    @Override
    public OFBsnGenericCommandReply.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnGenericCommandReplyVer14(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("status=").append(this.status);
        b.append(", ");
        b.append("tlvs=").append(this.tlvs);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnGenericCommandReplyVer14 other = (OFBsnGenericCommandReplyVer14)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.status != other.status) {
            return false;
        }
        return !(this.tlvs == null ? other.tlvs != null : !this.tlvs.equals(other.tlvs));
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnGenericCommandReplyVer14 other = (OFBsnGenericCommandReplyVer14)obj;
        if (this.status != other.status) {
            return false;
        }
        return !(this.tlvs == null ? other.tlvs != null : !this.tlvs.equals(other.tlvs));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * (int)(this.status ^ this.status >>> 32);
        result = 31 * result + (this.tlvs == null ? 0 : this.tlvs.hashCode());
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.status ^ this.status >>> 32);
        result = 31 * result + (this.tlvs == null ? 0 : this.tlvs.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnGenericCommandReplyVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnGenericCommandReplyVer14 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(5);
            bb.writeByte(4);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(6035143);
            bb.writeInt(72);
            bb.writeInt(U32.t(message.status));
            ChannelUtils.writeList(bb, message.tlvs);
            int length = bb.writerIndex() - startIndex;
            if (length > 65535) {
                throw new IllegalArgumentException("OFBsnGenericCommandReplyVer14: message length (" + length + ") exceeds maximum (0xFFFF)");
            }
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFBsnGenericCommandReplyVer14Funnel
    implements Funnel<OFBsnGenericCommandReplyVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnGenericCommandReplyVer14Funnel() {
        }

        public void funnel(OFBsnGenericCommandReplyVer14 message, PrimitiveSink sink) {
            sink.putByte((byte)5);
            sink.putByte((byte)4);
            sink.putLong(message.xid);
            sink.putInt(6035143);
            sink.putInt(72);
            sink.putLong(message.status);
            FunnelUtils.putList(message.tlvs, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnGenericCommandReply> {
        Reader() {
        }

        @Override
        public OFBsnGenericCommandReply readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 5) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_14(5), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 20) {
                throw new OFParseError("Wrong length: Expected to be >= 20, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 72) {
                throw new OFParseError("Wrong subtype: Expected=0x48L(0x48L), got=" + subtype);
            }
            long status = U32.f(bb.readInt());
            List<OFBsnTlv> tlvs = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFBsnTlvVer14.READER);
            OFBsnGenericCommandReplyVer14 bsnGenericCommandReplyVer14 = new OFBsnGenericCommandReplyVer14(xid, status, tlvs);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnGenericCommandReplyVer14);
            }
            return bsnGenericCommandReplyVer14;
        }
    }

    static class Builder
    implements OFBsnGenericCommandReply.Builder {
        private boolean xidSet;
        private long xid;
        private boolean statusSet;
        private long status;
        private boolean tlvsSet;
        private List<OFBsnTlv> tlvs;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnGenericCommandReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 72L;
        }

        @Override
        public long getStatus() {
            return this.status;
        }

        @Override
        public OFBsnGenericCommandReply.Builder setStatus(long status) {
            this.status = status;
            this.statusSet = true;
            return this;
        }

        @Override
        public List<OFBsnTlv> getTlvs() {
            return this.tlvs;
        }

        @Override
        public OFBsnGenericCommandReply.Builder setTlvs(List<OFBsnTlv> tlvs) {
            this.tlvs = tlvs;
            this.tlvsSet = true;
            return this;
        }

        @Override
        public OFBsnGenericCommandReply build() {
            List<OFBsnTlv> tlvs;
            long xid = this.xidSet ? this.xid : 0L;
            long status = this.statusSet ? this.status : 0L;
            List<OFBsnTlv> list = tlvs = this.tlvsSet ? this.tlvs : DEFAULT_TLVS;
            if (tlvs == null) {
                throw new NullPointerException("Property tlvs must not be null");
            }
            return new OFBsnGenericCommandReplyVer14(xid, status, tlvs);
        }
    }

    static class BuilderWithParent
    implements OFBsnGenericCommandReply.Builder {
        final OFBsnGenericCommandReplyVer14 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean statusSet;
        private long status;
        private boolean tlvsSet;
        private List<OFBsnTlv> tlvs;

        BuilderWithParent(OFBsnGenericCommandReplyVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnGenericCommandReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 72L;
        }

        @Override
        public long getStatus() {
            return this.status;
        }

        @Override
        public OFBsnGenericCommandReply.Builder setStatus(long status) {
            this.status = status;
            this.statusSet = true;
            return this;
        }

        @Override
        public List<OFBsnTlv> getTlvs() {
            return this.tlvs;
        }

        @Override
        public OFBsnGenericCommandReply.Builder setTlvs(List<OFBsnTlv> tlvs) {
            this.tlvs = tlvs;
            this.tlvsSet = true;
            return this;
        }

        @Override
        public OFBsnGenericCommandReply build() {
            List tlvs;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            long status = this.statusSet ? this.status : this.parentMessage.status;
            List list = tlvs = this.tlvsSet ? this.tlvs : this.parentMessage.tlvs;
            if (tlvs == null) {
                throw new NullPointerException("Property tlvs must not be null");
            }
            return new OFBsnGenericCommandReplyVer14(xid, status, tlvs);
        }
    }
}

