/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnExtendedCapabilities;

public class OFBsnExtendedCapabilitiesSerializerVer14 {
    public static final long BSN_EXT_CAP_AN_VAL = 1L;
    public static final long BSN_EXT_CAP_FEC_VAL = 2L;
    public static final long BSN_EXT_CAP_FEC_FIRE_CODE_VAL = 4L;
    public static final long BSN_EXT_CAP_FEC_REED_SOLOMON_VAL = 8L;
    public static final long BSN_EXT_CAP_FEC_REED_SOLOMON544_VAL = 16L;
    public static final long BSN_EXT_CAP_FEC_DISABLE_VAL = 32L;

    public static Set<OFBsnExtendedCapabilities> readFrom(ByteBuf bb) throws OFParseError {
        try {
            return OFBsnExtendedCapabilitiesSerializerVer14.ofWireValue(bb.readLong());
        }
        catch (IllegalArgumentException e) {
            throw new OFParseError(e);
        }
    }

    public static void writeTo(ByteBuf bb, Set<OFBsnExtendedCapabilities> set) {
        bb.writeLong(OFBsnExtendedCapabilitiesSerializerVer14.toWireValue(set));
    }

    public static void putTo(Set<OFBsnExtendedCapabilities> set, PrimitiveSink sink) {
        sink.putLong(OFBsnExtendedCapabilitiesSerializerVer14.toWireValue(set));
    }

    public static Set<OFBsnExtendedCapabilities> ofWireValue(long val) {
        EnumSet<OFBsnExtendedCapabilities> set = EnumSet.noneOf(OFBsnExtendedCapabilities.class);
        if ((val & 1L) != 0L) {
            set.add(OFBsnExtendedCapabilities.BSN_EXT_CAP_AN);
        }
        if ((val & 2L) != 0L) {
            set.add(OFBsnExtendedCapabilities.BSN_EXT_CAP_FEC);
        }
        if ((val & 4L) != 0L) {
            set.add(OFBsnExtendedCapabilities.BSN_EXT_CAP_FEC_FIRE_CODE);
        }
        if ((val & 8L) != 0L) {
            set.add(OFBsnExtendedCapabilities.BSN_EXT_CAP_FEC_REED_SOLOMON);
        }
        if ((val & 0x10L) != 0L) {
            set.add(OFBsnExtendedCapabilities.BSN_EXT_CAP_FEC_REED_SOLOMON544);
        }
        if ((val & 0x20L) != 0L) {
            set.add(OFBsnExtendedCapabilities.BSN_EXT_CAP_FEC_DISABLE);
        }
        return Collections.unmodifiableSet(set);
    }

    public static long toWireValue(Set<OFBsnExtendedCapabilities> set) {
        long wireValue = 0L;
        block8: for (OFBsnExtendedCapabilities e : set) {
            switch (e) {
                case BSN_EXT_CAP_AN: {
                    wireValue |= 1L;
                    continue block8;
                }
                case BSN_EXT_CAP_FEC: {
                    wireValue |= 2L;
                    continue block8;
                }
                case BSN_EXT_CAP_FEC_FIRE_CODE: {
                    wireValue |= 4L;
                    continue block8;
                }
                case BSN_EXT_CAP_FEC_REED_SOLOMON: {
                    wireValue |= 8L;
                    continue block8;
                }
                case BSN_EXT_CAP_FEC_REED_SOLOMON544: {
                    wireValue |= 0x10L;
                    continue block8;
                }
                case BSN_EXT_CAP_FEC_DISABLE: {
                    wireValue |= 0x20L;
                    continue block8;
                }
            }
            throw new IllegalArgumentException("Illegal enum value for type OFBsnExtendedCapabilities in version 1.4: " + (Object)((Object)e));
        }
        return wireValue;
    }
}

