/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.actionid.OFActionIdNiciraDecTtl;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionIdNiciraDecTtlVer14
implements OFActionIdNiciraDecTtl {
    private static final Logger logger = LoggerFactory.getLogger(OFActionIdNiciraDecTtlVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 10;
    static final OFActionIdNiciraDecTtlVer14 DEFAULT = new OFActionIdNiciraDecTtlVer14();
    static final OFActionIdNiciraDecTtlVer14 INSTANCE = new OFActionIdNiciraDecTtlVer14();
    static final Reader READER = new Reader();
    static final OFActionIdNiciraDecTtlVer14Funnel FUNNEL = new OFActionIdNiciraDecTtlVer14Funnel();
    static final Writer WRITER = new Writer();

    private OFActionIdNiciraDecTtlVer14() {
    }

    @Override
    public OFActionType getType() {
        return OFActionType.EXPERIMENTER;
    }

    @Override
    public long getExperimenter() {
        return 8992L;
    }

    @Override
    public int getSubtype() {
        return 18;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFActionIdNiciraDecTtl.Builder createBuilder() {
        throw new UnsupportedOperationException("OFActionIdNiciraDecTtlVer14 has no mutable properties -- builder unneeded");
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionIdNiciraDecTtlVer14(");
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionIdNiciraDecTtlVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFActionIdNiciraDecTtlVer14 message) {
            bb.writeShort(-1);
            bb.writeShort(10);
            bb.writeInt(8992);
            bb.writeShort(18);
        }
    }

    static class OFActionIdNiciraDecTtlVer14Funnel
    implements Funnel<OFActionIdNiciraDecTtlVer14> {
        private static final long serialVersionUID = 1L;

        OFActionIdNiciraDecTtlVer14Funnel() {
        }

        public void funnel(OFActionIdNiciraDecTtlVer14 message, PrimitiveSink sink) {
            sink.putShort((short)-1);
            sink.putShort((short)10);
            sink.putInt(8992);
            sink.putShort((short)18);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionIdNiciraDecTtl> {
        Reader() {
        }

        @Override
        public OFActionIdNiciraDecTtl readFrom(ByteBuf bb) throws OFParseError {
            int experimenter;
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != -1) {
                throw new OFParseError("Wrong type: Expected=OFActionType.EXPERIMENTER(65535), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 10) {
                throw new OFParseError("Wrong length: Expected=10(10), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if ((experimenter = bb.readInt()) != 8992) {
                throw new OFParseError("Wrong experimenter: Expected=0x2320L(0x2320L), got=" + experimenter);
            }
            short subtype = bb.readShort();
            if (subtype != 18) {
                throw new OFParseError("Wrong subtype: Expected=0x12(0x12), got=" + subtype);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - returning shared instance={}", (Object)INSTANCE);
            }
            return INSTANCE;
        }
    }
}

