/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFPacketIn;
import org.projectfloodlight.openflow.protocol.OFPacketInReason;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.Match;
import org.projectfloodlight.openflow.protocol.ver13.ChannelUtilsVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFFactoryVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFPacketInReasonSerializerVer13;
import org.projectfloodlight.openflow.types.OFBufferId;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.TableId;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U64;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFPacketInVer13
implements OFPacketIn {
    private static final Logger logger = LoggerFactory.getLogger(OFPacketInVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int MINIMUM_LENGTH = 34;
    static final int MAXIMUM_LENGTH = 65535;
    private static final long DEFAULT_XID = 0L;
    private static final OFBufferId DEFAULT_BUFFER_ID = OFBufferId.NO_BUFFER;
    private static final int DEFAULT_TOTAL_LEN = 0;
    private static final TableId DEFAULT_TABLE_ID = TableId.ALL;
    private static final U64 DEFAULT_COOKIE = U64.ZERO;
    private static final Match DEFAULT_MATCH = OFFactoryVer13.MATCH_WILDCARD_ALL;
    private static final byte[] DEFAULT_DATA = new byte[0];
    private final long xid;
    private final OFBufferId bufferId;
    private final int totalLen;
    private final OFPacketInReason reason;
    private final TableId tableId;
    private final U64 cookie;
    private final Match match;
    private final byte[] data;
    static final Reader READER = new Reader();
    static final OFPacketInVer13Funnel FUNNEL = new OFPacketInVer13Funnel();
    static final Writer WRITER = new Writer();

    OFPacketInVer13(long xid, OFBufferId bufferId, int totalLen, OFPacketInReason reason, TableId tableId, U64 cookie, Match match, byte[] data) {
        if (bufferId == null) {
            throw new NullPointerException("OFPacketInVer13: property bufferId cannot be null");
        }
        if (reason == null) {
            throw new NullPointerException("OFPacketInVer13: property reason cannot be null");
        }
        if (tableId == null) {
            throw new NullPointerException("OFPacketInVer13: property tableId cannot be null");
        }
        if (cookie == null) {
            throw new NullPointerException("OFPacketInVer13: property cookie cannot be null");
        }
        if (match == null) {
            throw new NullPointerException("OFPacketInVer13: property match cannot be null");
        }
        if (data == null) {
            throw new NullPointerException("OFPacketInVer13: property data cannot be null");
        }
        this.xid = U32.normalize(xid);
        this.bufferId = bufferId;
        this.totalLen = U16.normalize(totalLen);
        this.reason = reason;
        this.tableId = tableId;
        this.cookie = cookie;
        this.match = match;
        this.data = data;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFType getType() {
        return OFType.PACKET_IN;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFBufferId getBufferId() {
        return this.bufferId;
    }

    @Override
    public int getTotalLen() {
        return this.totalLen;
    }

    @Override
    public OFPort getInPort() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property inPort not supported in version 1.3");
    }

    @Override
    public OFPacketInReason getReason() {
        return this.reason;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public OFPort getInPhyPort() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property inPhyPort not supported in version 1.3");
    }

    @Override
    public TableId getTableId() {
        return this.tableId;
    }

    @Override
    public Match getMatch() {
        return this.match;
    }

    @Override
    public U64 getCookie() {
        return this.cookie;
    }

    @Override
    public OFPacketIn.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFPacketInVer13(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("bufferId=").append(this.bufferId);
        b.append(", ");
        b.append("totalLen=").append(this.totalLen);
        b.append(", ");
        b.append("reason=").append((Object)this.reason);
        b.append(", ");
        b.append("tableId=").append(this.tableId);
        b.append(", ");
        b.append("cookie=").append(this.cookie);
        b.append(", ");
        b.append("match=").append(this.match);
        b.append(", ");
        b.append("data=").append(Arrays.toString(this.data));
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFPacketInVer13 other = (OFPacketInVer13)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.bufferId == null ? other.bufferId != null : !this.bufferId.equals(other.bufferId)) {
            return false;
        }
        if (this.totalLen != other.totalLen) {
            return false;
        }
        if (this.reason == null ? other.reason != null : !this.reason.equals((Object)other.reason)) {
            return false;
        }
        if (this.tableId == null ? other.tableId != null : !this.tableId.equals(other.tableId)) {
            return false;
        }
        if (this.cookie == null ? other.cookie != null : !this.cookie.equals(other.cookie)) {
            return false;
        }
        if (this.match == null ? other.match != null : !this.match.equals(other.match)) {
            return false;
        }
        return Arrays.equals(this.data, other.data);
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFPacketInVer13 other = (OFPacketInVer13)obj;
        if (this.bufferId == null ? other.bufferId != null : !this.bufferId.equals(other.bufferId)) {
            return false;
        }
        if (this.totalLen != other.totalLen) {
            return false;
        }
        if (this.reason == null ? other.reason != null : !this.reason.equals((Object)other.reason)) {
            return false;
        }
        if (this.tableId == null ? other.tableId != null : !this.tableId.equals(other.tableId)) {
            return false;
        }
        if (this.cookie == null ? other.cookie != null : !this.cookie.equals(other.cookie)) {
            return false;
        }
        if (this.match == null ? other.match != null : !this.match.equals(other.match)) {
            return false;
        }
        return Arrays.equals(this.data, other.data);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.bufferId == null ? 0 : this.bufferId.hashCode());
        result = 31 * result + this.totalLen;
        result = 31 * result + (this.reason == null ? 0 : this.reason.hashCode());
        result = 31 * result + (this.tableId == null ? 0 : this.tableId.hashCode());
        result = 31 * result + (this.cookie == null ? 0 : this.cookie.hashCode());
        result = 31 * result + (this.match == null ? 0 : this.match.hashCode());
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bufferId == null ? 0 : this.bufferId.hashCode());
        result = 31 * result + this.totalLen;
        result = 31 * result + (this.reason == null ? 0 : this.reason.hashCode());
        result = 31 * result + (this.tableId == null ? 0 : this.tableId.hashCode());
        result = 31 * result + (this.cookie == null ? 0 : this.cookie.hashCode());
        result = 31 * result + (this.match == null ? 0 : this.match.hashCode());
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFPacketInVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFPacketInVer13 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(4);
            bb.writeByte(10);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(message.bufferId.getInt());
            bb.writeShort((int)U16.t(message.totalLen));
            OFPacketInReasonSerializerVer13.writeTo(bb, message.reason);
            message.tableId.writeByte(bb);
            bb.writeLong(message.cookie.getValue());
            message.match.writeTo(bb);
            bb.writeZero(2);
            bb.writeBytes(message.data);
            int length = bb.writerIndex() - startIndex;
            if (length > 65535) {
                throw new IllegalArgumentException("OFPacketInVer13: message length (" + length + ") exceeds maximum (0xFFFF)");
            }
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFPacketInVer13Funnel
    implements Funnel<OFPacketInVer13> {
        private static final long serialVersionUID = 1L;

        OFPacketInVer13Funnel() {
        }

        public void funnel(OFPacketInVer13 message, PrimitiveSink sink) {
            sink.putByte((byte)4);
            sink.putByte((byte)10);
            sink.putLong(message.xid);
            message.bufferId.putTo(sink);
            sink.putInt(message.totalLen);
            OFPacketInReasonSerializerVer13.putTo(message.reason, sink);
            message.tableId.putTo(sink);
            message.cookie.putTo(sink);
            message.match.putTo(sink);
            sink.putBytes(message.data);
        }
    }

    static class Reader
    implements OFMessageReader<OFPacketIn> {
        Reader() {
        }

        @Override
        public OFPacketIn readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 4) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_13(4), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 10) {
                throw new OFParseError("Wrong type: Expected=OFType.PACKET_IN(10), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 34) {
                throw new OFParseError("Wrong length: Expected to be >= 34, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            OFBufferId bufferId = OFBufferId.of(bb.readInt());
            int totalLen = U16.f(bb.readShort());
            OFPacketInReason reason = OFPacketInReasonSerializerVer13.readFrom(bb);
            TableId tableId = TableId.readByte(bb);
            U64 cookie = U64.ofRaw(bb.readLong());
            Match match = ChannelUtilsVer13.readOFMatch(bb);
            bb.skipBytes(2);
            byte[] data = ChannelUtils.readBytes(bb, length - (bb.readerIndex() - start));
            OFPacketInVer13 packetInVer13 = new OFPacketInVer13(xid, bufferId, totalLen, reason, tableId, cookie, match, data);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)packetInVer13);
            }
            return packetInVer13;
        }
    }

    static class Builder
    implements OFPacketIn.Builder {
        private boolean xidSet;
        private long xid;
        private boolean bufferIdSet;
        private OFBufferId bufferId;
        private boolean totalLenSet;
        private int totalLen;
        private boolean reasonSet;
        private OFPacketInReason reason;
        private boolean tableIdSet;
        private TableId tableId;
        private boolean cookieSet;
        private U64 cookie;
        private boolean matchSet;
        private Match match;
        private boolean dataSet;
        private byte[] data;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.PACKET_IN;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFPacketIn.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFBufferId getBufferId() {
            return this.bufferId;
        }

        @Override
        public OFPacketIn.Builder setBufferId(OFBufferId bufferId) {
            this.bufferId = bufferId;
            this.bufferIdSet = true;
            return this;
        }

        @Override
        public int getTotalLen() {
            return this.totalLen;
        }

        @Override
        public OFPacketIn.Builder setTotalLen(int totalLen) {
            this.totalLen = totalLen;
            this.totalLenSet = true;
            return this;
        }

        @Override
        public OFPort getInPort() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property inPort not supported in version 1.3");
        }

        @Override
        public OFPacketIn.Builder setInPort(OFPort inPort) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property inPort not supported in version 1.3");
        }

        @Override
        public OFPacketInReason getReason() {
            return this.reason;
        }

        @Override
        public OFPacketIn.Builder setReason(OFPacketInReason reason) {
            this.reason = reason;
            this.reasonSet = true;
            return this;
        }

        @Override
        public byte[] getData() {
            return this.data;
        }

        @Override
        public OFPacketIn.Builder setData(byte[] data) {
            this.data = data;
            this.dataSet = true;
            return this;
        }

        @Override
        public OFPort getInPhyPort() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property inPhyPort not supported in version 1.3");
        }

        @Override
        public OFPacketIn.Builder setInPhyPort(OFPort inPhyPort) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property inPhyPort not supported in version 1.3");
        }

        @Override
        public TableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFPacketIn.Builder setTableId(TableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public Match getMatch() {
            return this.match;
        }

        @Override
        public OFPacketIn.Builder setMatch(Match match) {
            this.match = match;
            this.matchSet = true;
            return this;
        }

        @Override
        public U64 getCookie() {
            return this.cookie;
        }

        @Override
        public OFPacketIn.Builder setCookie(U64 cookie) {
            this.cookie = cookie;
            this.cookieSet = true;
            return this;
        }

        @Override
        public OFPacketIn build() {
            byte[] data;
            Match match;
            U64 cookie;
            TableId tableId;
            int totalLen;
            OFBufferId bufferId;
            long xid = this.xidSet ? this.xid : 0L;
            OFBufferId oFBufferId = bufferId = this.bufferIdSet ? this.bufferId : DEFAULT_BUFFER_ID;
            if (bufferId == null) {
                throw new NullPointerException("Property bufferId must not be null");
            }
            int n = totalLen = this.totalLenSet ? this.totalLen : 0;
            if (!this.reasonSet) {
                throw new IllegalStateException("Property reason doesn't have default value -- must be set");
            }
            if (this.reason == null) {
                throw new NullPointerException("Property reason must not be null");
            }
            TableId tableId2 = tableId = this.tableIdSet ? this.tableId : DEFAULT_TABLE_ID;
            if (tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            U64 u64 = cookie = this.cookieSet ? this.cookie : DEFAULT_COOKIE;
            if (cookie == null) {
                throw new NullPointerException("Property cookie must not be null");
            }
            Match match2 = match = this.matchSet ? this.match : DEFAULT_MATCH;
            if (match == null) {
                throw new NullPointerException("Property match must not be null");
            }
            byte[] byArray = data = this.dataSet ? this.data : DEFAULT_DATA;
            if (data == null) {
                throw new NullPointerException("Property data must not be null");
            }
            return new OFPacketInVer13(xid, bufferId, totalLen, this.reason, tableId, cookie, match, data);
        }
    }

    static class BuilderWithParent
    implements OFPacketIn.Builder {
        final OFPacketInVer13 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean bufferIdSet;
        private OFBufferId bufferId;
        private boolean totalLenSet;
        private int totalLen;
        private boolean reasonSet;
        private OFPacketInReason reason;
        private boolean tableIdSet;
        private TableId tableId;
        private boolean cookieSet;
        private U64 cookie;
        private boolean matchSet;
        private Match match;
        private boolean dataSet;
        private byte[] data;

        BuilderWithParent(OFPacketInVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.PACKET_IN;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFPacketIn.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFBufferId getBufferId() {
            return this.bufferId;
        }

        @Override
        public OFPacketIn.Builder setBufferId(OFBufferId bufferId) {
            this.bufferId = bufferId;
            this.bufferIdSet = true;
            return this;
        }

        @Override
        public int getTotalLen() {
            return this.totalLen;
        }

        @Override
        public OFPacketIn.Builder setTotalLen(int totalLen) {
            this.totalLen = totalLen;
            this.totalLenSet = true;
            return this;
        }

        @Override
        public OFPort getInPort() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property inPort not supported in version 1.3");
        }

        @Override
        public OFPacketIn.Builder setInPort(OFPort inPort) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property inPort not supported in version 1.3");
        }

        @Override
        public OFPacketInReason getReason() {
            return this.reason;
        }

        @Override
        public OFPacketIn.Builder setReason(OFPacketInReason reason) {
            this.reason = reason;
            this.reasonSet = true;
            return this;
        }

        @Override
        public byte[] getData() {
            return this.data;
        }

        @Override
        public OFPacketIn.Builder setData(byte[] data) {
            this.data = data;
            this.dataSet = true;
            return this;
        }

        @Override
        public OFPort getInPhyPort() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property inPhyPort not supported in version 1.3");
        }

        @Override
        public OFPacketIn.Builder setInPhyPort(OFPort inPhyPort) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property inPhyPort not supported in version 1.3");
        }

        @Override
        public TableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFPacketIn.Builder setTableId(TableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public Match getMatch() {
            return this.match;
        }

        @Override
        public OFPacketIn.Builder setMatch(Match match) {
            this.match = match;
            this.matchSet = true;
            return this;
        }

        @Override
        public U64 getCookie() {
            return this.cookie;
        }

        @Override
        public OFPacketIn.Builder setCookie(U64 cookie) {
            this.cookie = cookie;
            this.cookieSet = true;
            return this;
        }

        @Override
        public OFPacketIn build() {
            byte[] data;
            Match match;
            U64 cookie;
            TableId tableId;
            OFPacketInReason reason;
            OFBufferId bufferId;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            OFBufferId oFBufferId = bufferId = this.bufferIdSet ? this.bufferId : this.parentMessage.bufferId;
            if (bufferId == null) {
                throw new NullPointerException("Property bufferId must not be null");
            }
            int totalLen = this.totalLenSet ? this.totalLen : this.parentMessage.totalLen;
            OFPacketInReason oFPacketInReason = reason = this.reasonSet ? this.reason : this.parentMessage.reason;
            if (reason == null) {
                throw new NullPointerException("Property reason must not be null");
            }
            TableId tableId2 = tableId = this.tableIdSet ? this.tableId : this.parentMessage.tableId;
            if (tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            U64 u64 = cookie = this.cookieSet ? this.cookie : this.parentMessage.cookie;
            if (cookie == null) {
                throw new NullPointerException("Property cookie must not be null");
            }
            Match match2 = match = this.matchSet ? this.match : this.parentMessage.match;
            if (match == null) {
                throw new NullPointerException("Property match must not be null");
            }
            byte[] byArray = data = this.dataSet ? this.data : this.parentMessage.data;
            if (data == null) {
                throw new NullPointerException("Property data must not be null");
            }
            return new OFPacketInVer13(xid, bufferId, totalLen, reason, tableId, cookie, match, data);
        }
    }
}

