/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmIpProto;
import org.projectfloodlight.openflow.types.IpProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmIpProtoVer13
implements OFOxmIpProto {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmIpProtoVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 5;
    private static final IpProtocol DEFAULT_VALUE = IpProtocol.NONE;
    private final IpProtocol value;
    static final OFOxmIpProtoVer13 DEFAULT = new OFOxmIpProtoVer13(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmIpProtoVer13Funnel FUNNEL = new OFOxmIpProtoVer13Funnel();
    static final Writer WRITER = new Writer();

    OFOxmIpProtoVer13(IpProtocol value) {
        if (value == null) {
            throw new NullPointerException("OFOxmIpProtoVer13: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 2147488769L;
    }

    @Override
    public IpProtocol getValue() {
        return this.value;
    }

    @Override
    public MatchField<IpProtocol> getMatchField() {
        return MatchField.IP_PROTO;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<IpProtocol> getCanonical() {
        return this;
    }

    @Override
    public IpProtocol getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.3");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFOxmIpProto.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmIpProtoVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmIpProtoVer13 other = (OFOxmIpProtoVer13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmIpProtoVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmIpProtoVer13 message) {
            bb.writeInt(-2147478527);
            message.value.writeByte(bb);
        }
    }

    static class OFOxmIpProtoVer13Funnel
    implements Funnel<OFOxmIpProtoVer13> {
        private static final long serialVersionUID = 1L;

        OFOxmIpProtoVer13Funnel() {
        }

        public void funnel(OFOxmIpProtoVer13 message, PrimitiveSink sink) {
            sink.putInt(-2147478527);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmIpProto> {
        Reader() {
        }

        @Override
        public OFOxmIpProto readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -2147478527) {
                throw new OFParseError("Wrong typeLen: Expected=0x80001401L(0x80001401L), got=" + typeLen);
            }
            IpProtocol value = IpProtocol.readByte(bb);
            OFOxmIpProtoVer13 oxmIpProtoVer13 = new OFOxmIpProtoVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmIpProtoVer13);
            }
            return oxmIpProtoVer13;
        }
    }

    static class Builder
    implements OFOxmIpProto.Builder {
        private boolean valueSet;
        private IpProtocol value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 2147488769L;
        }

        @Override
        public IpProtocol getValue() {
            return this.value;
        }

        @Override
        public OFOxmIpProto.Builder setValue(IpProtocol value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<IpProtocol> getMatchField() {
            return MatchField.IP_PROTO;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<IpProtocol> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public IpProtocol getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmIpProto build() {
            IpProtocol value;
            IpProtocol ipProtocol = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmIpProtoVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmIpProto.Builder {
        final OFOxmIpProtoVer13 parentMessage;
        private boolean valueSet;
        private IpProtocol value;

        BuilderWithParent(OFOxmIpProtoVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 2147488769L;
        }

        @Override
        public IpProtocol getValue() {
            return this.value;
        }

        @Override
        public OFOxmIpProto.Builder setValue(IpProtocol value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<IpProtocol> getMatchField() {
            return MatchField.IP_PROTO;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<IpProtocol> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public IpProtocol getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmIpProto build() {
            IpProtocol value;
            IpProtocol ipProtocol = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmIpProtoVer13(value);
        }
    }
}

