/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmConnTrackingTpSrcMasked;
import org.projectfloodlight.openflow.protocol.ver13.OFOxmConnTrackingTpSrcVer13;
import org.projectfloodlight.openflow.types.TransportPort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmConnTrackingTpSrcMaskedVer13
implements OFOxmConnTrackingTpSrcMasked {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmConnTrackingTpSrcMaskedVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 8;
    private static final TransportPort DEFAULT_VALUE = TransportPort.NONE;
    private static final TransportPort DEFAULT_VALUE_MASK = TransportPort.NONE;
    private final TransportPort value;
    private final TransportPort mask;
    static final OFOxmConnTrackingTpSrcMaskedVer13 DEFAULT = new OFOxmConnTrackingTpSrcMaskedVer13(DEFAULT_VALUE, DEFAULT_VALUE_MASK);
    static final Reader READER = new Reader();
    static final OFOxmConnTrackingTpSrcMaskedVer13Funnel FUNNEL = new OFOxmConnTrackingTpSrcMaskedVer13Funnel();
    static final Writer WRITER = new Writer();

    OFOxmConnTrackingTpSrcMaskedVer13(TransportPort value, TransportPort mask) {
        if (value == null) {
            throw new NullPointerException("OFOxmConnTrackingTpSrcMaskedVer13: property value cannot be null");
        }
        if (mask == null) {
            throw new NullPointerException("OFOxmConnTrackingTpSrcMaskedVer13: property mask cannot be null");
        }
        this.value = value;
        this.mask = mask;
    }

    @Override
    public long getTypeLen() {
        return 129284L;
    }

    @Override
    public TransportPort getValue() {
        return this.value;
    }

    @Override
    public TransportPort getMask() {
        return this.mask;
    }

    @Override
    public MatchField<TransportPort> getMatchField() {
        return MatchField.CONN_TRACKING_TP_SRC;
    }

    @Override
    public boolean isMasked() {
        return true;
    }

    @Override
    public OFOxm<TransportPort> getCanonical() {
        if (TransportPort.NO_MASK.equals(this.mask)) {
            return new OFOxmConnTrackingTpSrcVer13(this.value);
        }
        if (TransportPort.FULL_MASK.equals(this.mask)) {
            return null;
        }
        return this;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFOxmConnTrackingTpSrcMasked.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmConnTrackingTpSrcMaskedVer13(");
        b.append("value=").append(this.value);
        b.append(", ");
        b.append("mask=").append(this.mask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmConnTrackingTpSrcMaskedVer13 other = (OFOxmConnTrackingTpSrcMaskedVer13)obj;
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.mask == null ? other.mask != null : !this.mask.equals(other.mask));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.mask == null ? 0 : this.mask.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmConnTrackingTpSrcMaskedVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmConnTrackingTpSrcMaskedVer13 message) {
            bb.writeInt(129284);
            message.value.write2Bytes(bb);
            message.mask.write2Bytes(bb);
        }
    }

    static class OFOxmConnTrackingTpSrcMaskedVer13Funnel
    implements Funnel<OFOxmConnTrackingTpSrcMaskedVer13> {
        private static final long serialVersionUID = 1L;

        OFOxmConnTrackingTpSrcMaskedVer13Funnel() {
        }

        public void funnel(OFOxmConnTrackingTpSrcMaskedVer13 message, PrimitiveSink sink) {
            sink.putInt(129284);
            message.value.putTo(sink);
            message.mask.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmConnTrackingTpSrcMasked> {
        Reader() {
        }

        @Override
        public OFOxmConnTrackingTpSrcMasked readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 129284) {
                throw new OFParseError("Wrong typeLen: Expected=0x1f904L(0x1f904L), got=" + typeLen);
            }
            TransportPort value = TransportPort.read2Bytes(bb);
            TransportPort mask = TransportPort.read2Bytes(bb);
            OFOxmConnTrackingTpSrcMaskedVer13 oxmConnTrackingTpSrcMaskedVer13 = new OFOxmConnTrackingTpSrcMaskedVer13(value, mask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmConnTrackingTpSrcMaskedVer13);
            }
            return oxmConnTrackingTpSrcMaskedVer13;
        }
    }

    static class Builder
    implements OFOxmConnTrackingTpSrcMasked.Builder {
        private boolean valueSet;
        private TransportPort value;
        private boolean maskSet;
        private TransportPort mask;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 129284L;
        }

        @Override
        public TransportPort getValue() {
            return this.value;
        }

        @Override
        public OFOxmConnTrackingTpSrcMasked.Builder setValue(TransportPort value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public TransportPort getMask() {
            return this.mask;
        }

        @Override
        public OFOxmConnTrackingTpSrcMasked.Builder setMask(TransportPort mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<TransportPort> getMatchField() {
            return MatchField.CONN_TRACKING_TP_SRC;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<TransportPort> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmConnTrackingTpSrcMasked build() {
            TransportPort mask;
            TransportPort value;
            TransportPort transportPort = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            TransportPort transportPort2 = mask = this.maskSet ? this.mask : DEFAULT_VALUE_MASK;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmConnTrackingTpSrcMaskedVer13(value, mask);
        }
    }

    static class BuilderWithParent
    implements OFOxmConnTrackingTpSrcMasked.Builder {
        final OFOxmConnTrackingTpSrcMaskedVer13 parentMessage;
        private boolean valueSet;
        private TransportPort value;
        private boolean maskSet;
        private TransportPort mask;

        BuilderWithParent(OFOxmConnTrackingTpSrcMaskedVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 129284L;
        }

        @Override
        public TransportPort getValue() {
            return this.value;
        }

        @Override
        public OFOxmConnTrackingTpSrcMasked.Builder setValue(TransportPort value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public TransportPort getMask() {
            return this.mask;
        }

        @Override
        public OFOxmConnTrackingTpSrcMasked.Builder setMask(TransportPort mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<TransportPort> getMatchField() {
            return MatchField.CONN_TRACKING_TP_SRC;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<TransportPort> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmConnTrackingTpSrcMasked build() {
            TransportPort mask;
            TransportPort value;
            TransportPort transportPort = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            TransportPort transportPort2 = mask = this.maskSet ? this.mask : this.parentMessage.mask;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmConnTrackingTpSrcMaskedVer13(value, mask);
        }
    }
}

