/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmBsnUdf7;
import org.projectfloodlight.openflow.types.UDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmBsnUdf7Ver13
implements OFOxmBsnUdf7 {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmBsnUdf7Ver13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 8;
    private static final UDF DEFAULT_VALUE = UDF.ZERO;
    private final UDF value;
    static final OFOxmBsnUdf7Ver13 DEFAULT = new OFOxmBsnUdf7Ver13(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmBsnUdf7Ver13Funnel FUNNEL = new OFOxmBsnUdf7Ver13Funnel();
    static final Writer WRITER = new Writer();

    OFOxmBsnUdf7Ver13(UDF value) {
        if (value == null) {
            throw new NullPointerException("OFOxmBsnUdf7Ver13: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 204292L;
    }

    @Override
    public UDF getValue() {
        return this.value;
    }

    @Override
    public MatchField<UDF> getMatchField() {
        return MatchField.BSN_UDF7;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<UDF> getCanonical() {
        return this;
    }

    @Override
    public UDF getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.3");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFOxmBsnUdf7.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmBsnUdf7Ver13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmBsnUdf7Ver13 other = (OFOxmBsnUdf7Ver13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmBsnUdf7Ver13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmBsnUdf7Ver13 message) {
            bb.writeInt(204292);
            message.value.write4Bytes(bb);
        }
    }

    static class OFOxmBsnUdf7Ver13Funnel
    implements Funnel<OFOxmBsnUdf7Ver13> {
        private static final long serialVersionUID = 1L;

        OFOxmBsnUdf7Ver13Funnel() {
        }

        public void funnel(OFOxmBsnUdf7Ver13 message, PrimitiveSink sink) {
            sink.putInt(204292);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmBsnUdf7> {
        Reader() {
        }

        @Override
        public OFOxmBsnUdf7 readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 204292) {
                throw new OFParseError("Wrong typeLen: Expected=0x31e04L(0x31e04L), got=" + typeLen);
            }
            UDF value = UDF.read4Bytes(bb);
            OFOxmBsnUdf7Ver13 oxmBsnUdf7Ver13 = new OFOxmBsnUdf7Ver13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmBsnUdf7Ver13);
            }
            return oxmBsnUdf7Ver13;
        }
    }

    static class Builder
    implements OFOxmBsnUdf7.Builder {
        private boolean valueSet;
        private UDF value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 204292L;
        }

        @Override
        public UDF getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnUdf7.Builder setValue(UDF value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<UDF> getMatchField() {
            return MatchField.BSN_UDF7;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<UDF> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public UDF getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmBsnUdf7 build() {
            UDF value;
            UDF uDF = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmBsnUdf7Ver13(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmBsnUdf7.Builder {
        final OFOxmBsnUdf7Ver13 parentMessage;
        private boolean valueSet;
        private UDF value;

        BuilderWithParent(OFOxmBsnUdf7Ver13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 204292L;
        }

        @Override
        public UDF getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnUdf7.Builder setValue(UDF value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<UDF> getMatchField() {
            return MatchField.BSN_UDF7;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<UDF> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public UDF getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmBsnUdf7 build() {
            UDF value;
            UDF uDF = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmBsnUdf7Ver13(value);
        }
    }
}

