/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmBsnUdf5;
import org.projectfloodlight.openflow.types.UDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmBsnUdf5Ver13
implements OFOxmBsnUdf5 {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmBsnUdf5Ver13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 8;
    private static final UDF DEFAULT_VALUE = UDF.ZERO;
    private final UDF value;
    static final OFOxmBsnUdf5Ver13 DEFAULT = new OFOxmBsnUdf5Ver13(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmBsnUdf5Ver13Funnel FUNNEL = new OFOxmBsnUdf5Ver13Funnel();
    static final Writer WRITER = new Writer();

    OFOxmBsnUdf5Ver13(UDF value) {
        if (value == null) {
            throw new NullPointerException("OFOxmBsnUdf5Ver13: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 203268L;
    }

    @Override
    public UDF getValue() {
        return this.value;
    }

    @Override
    public MatchField<UDF> getMatchField() {
        return MatchField.BSN_UDF5;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<UDF> getCanonical() {
        return this;
    }

    @Override
    public UDF getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.3");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFOxmBsnUdf5.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmBsnUdf5Ver13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmBsnUdf5Ver13 other = (OFOxmBsnUdf5Ver13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmBsnUdf5Ver13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmBsnUdf5Ver13 message) {
            bb.writeInt(203268);
            message.value.write4Bytes(bb);
        }
    }

    static class OFOxmBsnUdf5Ver13Funnel
    implements Funnel<OFOxmBsnUdf5Ver13> {
        private static final long serialVersionUID = 1L;

        OFOxmBsnUdf5Ver13Funnel() {
        }

        public void funnel(OFOxmBsnUdf5Ver13 message, PrimitiveSink sink) {
            sink.putInt(203268);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmBsnUdf5> {
        Reader() {
        }

        @Override
        public OFOxmBsnUdf5 readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 203268) {
                throw new OFParseError("Wrong typeLen: Expected=0x31a04L(0x31a04L), got=" + typeLen);
            }
            UDF value = UDF.read4Bytes(bb);
            OFOxmBsnUdf5Ver13 oxmBsnUdf5Ver13 = new OFOxmBsnUdf5Ver13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmBsnUdf5Ver13);
            }
            return oxmBsnUdf5Ver13;
        }
    }

    static class Builder
    implements OFOxmBsnUdf5.Builder {
        private boolean valueSet;
        private UDF value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 203268L;
        }

        @Override
        public UDF getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnUdf5.Builder setValue(UDF value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<UDF> getMatchField() {
            return MatchField.BSN_UDF5;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<UDF> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public UDF getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmBsnUdf5 build() {
            UDF value;
            UDF uDF = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmBsnUdf5Ver13(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmBsnUdf5.Builder {
        final OFOxmBsnUdf5Ver13 parentMessage;
        private boolean valueSet;
        private UDF value;

        BuilderWithParent(OFOxmBsnUdf5Ver13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 203268L;
        }

        @Override
        public UDF getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnUdf5.Builder setValue(UDF value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<UDF> getMatchField() {
            return MatchField.BSN_UDF5;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<UDF> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public UDF getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmBsnUdf5 build() {
            UDF value;
            UDF uDF = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmBsnUdf5Ver13(value);
        }
    }
}

