/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmBsnInPorts512Masked;
import org.projectfloodlight.openflow.protocol.ver13.OFOxmBsnInPorts512Ver13;
import org.projectfloodlight.openflow.types.OFBitMask512;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmBsnInPorts512MaskedVer13
implements OFOxmBsnInPorts512Masked {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmBsnInPorts512MaskedVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 132;
    private static final OFBitMask512 DEFAULT_VALUE = OFBitMask512.NONE;
    private static final OFBitMask512 DEFAULT_VALUE_MASK = OFBitMask512.NONE;
    private final OFBitMask512 value;
    private final OFBitMask512 mask;
    static final OFOxmBsnInPorts512MaskedVer13 DEFAULT = new OFOxmBsnInPorts512MaskedVer13(DEFAULT_VALUE, DEFAULT_VALUE_MASK);
    static final Reader READER = new Reader();
    static final OFOxmBsnInPorts512MaskedVer13Funnel FUNNEL = new OFOxmBsnInPorts512MaskedVer13Funnel();
    static final Writer WRITER = new Writer();

    OFOxmBsnInPorts512MaskedVer13(OFBitMask512 value, OFBitMask512 mask) {
        if (value == null) {
            throw new NullPointerException("OFOxmBsnInPorts512MaskedVer13: property value cannot be null");
        }
        if (mask == null) {
            throw new NullPointerException("OFOxmBsnInPorts512MaskedVer13: property mask cannot be null");
        }
        this.value = value;
        this.mask = mask;
    }

    @Override
    public long getTypeLen() {
        return 206720L;
    }

    @Override
    public OFBitMask512 getValue() {
        return this.value;
    }

    @Override
    public OFBitMask512 getMask() {
        return this.mask;
    }

    @Override
    public MatchField<OFBitMask512> getMatchField() {
        return MatchField.BSN_IN_PORTS_512;
    }

    @Override
    public boolean isMasked() {
        return true;
    }

    @Override
    public OFOxm<OFBitMask512> getCanonical() {
        if (OFBitMask512.NO_MASK.equals(this.mask)) {
            return new OFOxmBsnInPorts512Ver13(this.value);
        }
        if (OFBitMask512.FULL_MASK.equals(this.mask)) {
            return null;
        }
        return this;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFOxmBsnInPorts512Masked.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmBsnInPorts512MaskedVer13(");
        b.append("value=").append(this.value);
        b.append(", ");
        b.append("mask=").append(this.mask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmBsnInPorts512MaskedVer13 other = (OFOxmBsnInPorts512MaskedVer13)obj;
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.mask == null ? other.mask != null : !this.mask.equals(other.mask));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.mask == null ? 0 : this.mask.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmBsnInPorts512MaskedVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmBsnInPorts512MaskedVer13 message) {
            bb.writeInt(206720);
            message.value.write64Bytes(bb);
            message.mask.write64Bytes(bb);
        }
    }

    static class OFOxmBsnInPorts512MaskedVer13Funnel
    implements Funnel<OFOxmBsnInPorts512MaskedVer13> {
        private static final long serialVersionUID = 1L;

        OFOxmBsnInPorts512MaskedVer13Funnel() {
        }

        public void funnel(OFOxmBsnInPorts512MaskedVer13 message, PrimitiveSink sink) {
            sink.putInt(206720);
            message.value.putTo(sink);
            message.mask.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmBsnInPorts512Masked> {
        Reader() {
        }

        @Override
        public OFOxmBsnInPorts512Masked readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 206720) {
                throw new OFParseError("Wrong typeLen: Expected=0x32780L(0x32780L), got=" + typeLen);
            }
            OFBitMask512 value = OFBitMask512.read64Bytes(bb);
            OFBitMask512 mask = OFBitMask512.read64Bytes(bb);
            OFOxmBsnInPorts512MaskedVer13 oxmBsnInPorts512MaskedVer13 = new OFOxmBsnInPorts512MaskedVer13(value, mask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmBsnInPorts512MaskedVer13);
            }
            return oxmBsnInPorts512MaskedVer13;
        }
    }

    static class Builder
    implements OFOxmBsnInPorts512Masked.Builder {
        private boolean valueSet;
        private OFBitMask512 value;
        private boolean maskSet;
        private OFBitMask512 mask;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 206720L;
        }

        @Override
        public OFBitMask512 getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnInPorts512Masked.Builder setValue(OFBitMask512 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFBitMask512 getMask() {
            return this.mask;
        }

        @Override
        public OFOxmBsnInPorts512Masked.Builder setMask(OFBitMask512 mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<OFBitMask512> getMatchField() {
            return MatchField.BSN_IN_PORTS_512;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<OFBitMask512> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmBsnInPorts512Masked build() {
            OFBitMask512 mask;
            OFBitMask512 value;
            OFBitMask512 oFBitMask512 = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            OFBitMask512 oFBitMask5122 = mask = this.maskSet ? this.mask : DEFAULT_VALUE_MASK;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmBsnInPorts512MaskedVer13(value, mask);
        }
    }

    static class BuilderWithParent
    implements OFOxmBsnInPorts512Masked.Builder {
        final OFOxmBsnInPorts512MaskedVer13 parentMessage;
        private boolean valueSet;
        private OFBitMask512 value;
        private boolean maskSet;
        private OFBitMask512 mask;

        BuilderWithParent(OFOxmBsnInPorts512MaskedVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 206720L;
        }

        @Override
        public OFBitMask512 getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnInPorts512Masked.Builder setValue(OFBitMask512 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFBitMask512 getMask() {
            return this.mask;
        }

        @Override
        public OFOxmBsnInPorts512Masked.Builder setMask(OFBitMask512 mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<OFBitMask512> getMatchField() {
            return MatchField.BSN_IN_PORTS_512;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<OFBitMask512> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmBsnInPorts512Masked build() {
            OFBitMask512 mask;
            OFBitMask512 value;
            OFBitMask512 oFBitMask512 = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            OFBitMask512 oFBitMask5122 = mask = this.maskSet ? this.mask : this.parentMessage.mask;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmBsnInPorts512MaskedVer13(value, mask);
        }
    }
}

