/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmArpShaMasked;
import org.projectfloodlight.openflow.protocol.ver13.OFOxmArpShaVer13;
import org.projectfloodlight.openflow.types.MacAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmArpShaMaskedVer13
implements OFOxmArpShaMasked {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmArpShaMaskedVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 16;
    private static final MacAddress DEFAULT_VALUE = MacAddress.NONE;
    private static final MacAddress DEFAULT_VALUE_MASK = MacAddress.NONE;
    private final MacAddress value;
    private final MacAddress mask;
    static final OFOxmArpShaMaskedVer13 DEFAULT = new OFOxmArpShaMaskedVer13(DEFAULT_VALUE, DEFAULT_VALUE_MASK);
    static final Reader READER = new Reader();
    static final OFOxmArpShaMaskedVer13Funnel FUNNEL = new OFOxmArpShaMaskedVer13Funnel();
    static final Writer WRITER = new Writer();

    OFOxmArpShaMaskedVer13(MacAddress value, MacAddress mask) {
        if (value == null) {
            throw new NullPointerException("OFOxmArpShaMaskedVer13: property value cannot be null");
        }
        if (mask == null) {
            throw new NullPointerException("OFOxmArpShaMaskedVer13: property mask cannot be null");
        }
        this.value = value;
        this.mask = mask;
    }

    @Override
    public long getTypeLen() {
        return 2147496204L;
    }

    @Override
    public MacAddress getValue() {
        return this.value;
    }

    @Override
    public MacAddress getMask() {
        return this.mask;
    }

    @Override
    public MatchField<MacAddress> getMatchField() {
        return MatchField.ARP_SHA;
    }

    @Override
    public boolean isMasked() {
        return true;
    }

    @Override
    public OFOxm<MacAddress> getCanonical() {
        if (MacAddress.NO_MASK.equals(this.mask)) {
            return new OFOxmArpShaVer13(this.value);
        }
        if (MacAddress.FULL_MASK.equals(this.mask)) {
            return null;
        }
        return this;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFOxmArpShaMasked.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmArpShaMaskedVer13(");
        b.append("value=").append(this.value);
        b.append(", ");
        b.append("mask=").append(this.mask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmArpShaMaskedVer13 other = (OFOxmArpShaMaskedVer13)obj;
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.mask == null ? other.mask != null : !this.mask.equals(other.mask));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.mask == null ? 0 : this.mask.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmArpShaMaskedVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmArpShaMaskedVer13 message) {
            bb.writeInt(-2147471092);
            message.value.write6Bytes(bb);
            message.mask.write6Bytes(bb);
        }
    }

    static class OFOxmArpShaMaskedVer13Funnel
    implements Funnel<OFOxmArpShaMaskedVer13> {
        private static final long serialVersionUID = 1L;

        OFOxmArpShaMaskedVer13Funnel() {
        }

        public void funnel(OFOxmArpShaMaskedVer13 message, PrimitiveSink sink) {
            sink.putInt(-2147471092);
            message.value.putTo(sink);
            message.mask.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmArpShaMasked> {
        Reader() {
        }

        @Override
        public OFOxmArpShaMasked readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -2147471092) {
                throw new OFParseError("Wrong typeLen: Expected=0x8000310cL(0x8000310cL), got=" + typeLen);
            }
            MacAddress value = MacAddress.read6Bytes(bb);
            MacAddress mask = MacAddress.read6Bytes(bb);
            OFOxmArpShaMaskedVer13 oxmArpShaMaskedVer13 = new OFOxmArpShaMaskedVer13(value, mask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmArpShaMaskedVer13);
            }
            return oxmArpShaMaskedVer13;
        }
    }

    static class Builder
    implements OFOxmArpShaMasked.Builder {
        private boolean valueSet;
        private MacAddress value;
        private boolean maskSet;
        private MacAddress mask;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 2147496204L;
        }

        @Override
        public MacAddress getValue() {
            return this.value;
        }

        @Override
        public OFOxmArpShaMasked.Builder setValue(MacAddress value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MacAddress getMask() {
            return this.mask;
        }

        @Override
        public OFOxmArpShaMasked.Builder setMask(MacAddress mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<MacAddress> getMatchField() {
            return MatchField.ARP_SHA;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<MacAddress> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmArpShaMasked build() {
            MacAddress mask;
            MacAddress value;
            MacAddress macAddress = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            MacAddress macAddress2 = mask = this.maskSet ? this.mask : DEFAULT_VALUE_MASK;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmArpShaMaskedVer13(value, mask);
        }
    }

    static class BuilderWithParent
    implements OFOxmArpShaMasked.Builder {
        final OFOxmArpShaMaskedVer13 parentMessage;
        private boolean valueSet;
        private MacAddress value;
        private boolean maskSet;
        private MacAddress mask;

        BuilderWithParent(OFOxmArpShaMaskedVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 2147496204L;
        }

        @Override
        public MacAddress getValue() {
            return this.value;
        }

        @Override
        public OFOxmArpShaMasked.Builder setValue(MacAddress value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MacAddress getMask() {
            return this.mask;
        }

        @Override
        public OFOxmArpShaMasked.Builder setMask(MacAddress mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<MacAddress> getMatchField() {
            return MatchField.ARP_SHA;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<MacAddress> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmArpShaMasked build() {
            MacAddress mask;
            MacAddress value;
            MacAddress macAddress = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            MacAddress macAddress2 = mask = this.maskSet ? this.mask : this.parentMessage.mask;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmArpShaMaskedVer13(value, mask);
        }
    }
}

