/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFMeterFlags;
import org.projectfloodlight.openflow.protocol.OFMeterMod;
import org.projectfloodlight.openflow.protocol.OFMeterModCommand;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.meterband.OFMeterBand;
import org.projectfloodlight.openflow.protocol.ver13.OFMeterBandVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFMeterFlagsSerializerVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFMeterModCommandSerializerVer13;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFMeterModVer13
implements OFMeterMod {
    private static final Logger logger = LoggerFactory.getLogger(OFMeterModVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int MINIMUM_LENGTH = 16;
    static final int MAXIMUM_LENGTH = 65535;
    private static final long DEFAULT_XID = 0L;
    private static final Set<OFMeterFlags> DEFAULT_FLAGS = ImmutableSet.of();
    private static final long DEFAULT_METER_ID = 0L;
    private static final List<OFMeterBand> DEFAULT_METERS = ImmutableList.of();
    private final long xid;
    private final OFMeterModCommand command;
    private final Set<OFMeterFlags> flags;
    private final long meterId;
    private final List<OFMeterBand> meters;
    static final Reader READER = new Reader();
    static final OFMeterModVer13Funnel FUNNEL = new OFMeterModVer13Funnel();
    static final Writer WRITER = new Writer();

    OFMeterModVer13(long xid, OFMeterModCommand command, Set<OFMeterFlags> flags, long meterId, List<OFMeterBand> meters) {
        if (command == null) {
            throw new NullPointerException("OFMeterModVer13: property command cannot be null");
        }
        if (flags == null) {
            throw new NullPointerException("OFMeterModVer13: property flags cannot be null");
        }
        if (meters == null) {
            throw new NullPointerException("OFMeterModVer13: property meters cannot be null");
        }
        this.xid = U32.normalize(xid);
        this.command = command;
        this.flags = flags;
        this.meterId = U32.normalize(meterId);
        this.meters = meters;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFType getType() {
        return OFType.METER_MOD;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFMeterModCommand getCommand() {
        return this.command;
    }

    @Override
    public Set<OFMeterFlags> getFlags() {
        return this.flags;
    }

    @Override
    public long getMeterId() {
        return this.meterId;
    }

    @Override
    public List<OFMeterBand> getMeters() {
        return this.meters;
    }

    @Override
    public List<OFMeterBand> getBands() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property bands not supported in version 1.3");
    }

    @Override
    public OFMeterMod.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFMeterModVer13(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("command=").append((Object)this.command);
        b.append(", ");
        b.append("flags=").append(this.flags);
        b.append(", ");
        b.append("meterId=").append(this.meterId);
        b.append(", ");
        b.append("meters=").append(this.meters);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFMeterModVer13 other = (OFMeterModVer13)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.command == null ? other.command != null : !this.command.equals((Object)other.command)) {
            return false;
        }
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        if (this.meterId != other.meterId) {
            return false;
        }
        return !(this.meters == null ? other.meters != null : !this.meters.equals(other.meters));
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFMeterModVer13 other = (OFMeterModVer13)obj;
        if (this.command == null ? other.command != null : !this.command.equals((Object)other.command)) {
            return false;
        }
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        if (this.meterId != other.meterId) {
            return false;
        }
        return !(this.meters == null ? other.meters != null : !this.meters.equals(other.meters));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.command == null ? 0 : this.command.hashCode());
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * (int)(this.meterId ^ this.meterId >>> 32);
        result = 31 * result + (this.meters == null ? 0 : this.meters.hashCode());
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.command == null ? 0 : this.command.hashCode());
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * (int)(this.meterId ^ this.meterId >>> 32);
        result = 31 * result + (this.meters == null ? 0 : this.meters.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFMeterModVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFMeterModVer13 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(4);
            bb.writeByte(29);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            OFMeterModCommandSerializerVer13.writeTo(bb, message.command);
            OFMeterFlagsSerializerVer13.writeTo(bb, message.flags);
            bb.writeInt(U32.t(message.meterId));
            ChannelUtils.writeList(bb, message.meters);
            int length = bb.writerIndex() - startIndex;
            if (length > 65535) {
                throw new IllegalArgumentException("OFMeterModVer13: message length (" + length + ") exceeds maximum (0xFFFF)");
            }
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFMeterModVer13Funnel
    implements Funnel<OFMeterModVer13> {
        private static final long serialVersionUID = 1L;

        OFMeterModVer13Funnel() {
        }

        public void funnel(OFMeterModVer13 message, PrimitiveSink sink) {
            sink.putByte((byte)4);
            sink.putByte((byte)29);
            sink.putLong(message.xid);
            OFMeterModCommandSerializerVer13.putTo(message.command, sink);
            OFMeterFlagsSerializerVer13.putTo(message.flags, sink);
            sink.putLong(message.meterId);
            FunnelUtils.putList(message.meters, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFMeterMod> {
        Reader() {
        }

        @Override
        public OFMeterMod readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 4) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_13(4), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 29) {
                throw new OFParseError("Wrong type: Expected=OFType.METER_MOD(29), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 16) {
                throw new OFParseError("Wrong length: Expected to be >= 16, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            OFMeterModCommand command = OFMeterModCommandSerializerVer13.readFrom(bb);
            Set<OFMeterFlags> flags = OFMeterFlagsSerializerVer13.readFrom(bb);
            long meterId = U32.f(bb.readInt());
            List<OFMeterBand> meters = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFMeterBandVer13.READER);
            OFMeterModVer13 meterModVer13 = new OFMeterModVer13(xid, command, flags, meterId, meters);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)meterModVer13);
            }
            return meterModVer13;
        }
    }

    static class Builder
    implements OFMeterMod.Builder {
        private boolean xidSet;
        private long xid;
        private boolean commandSet;
        private OFMeterModCommand command;
        private boolean flagsSet;
        private Set<OFMeterFlags> flags;
        private boolean meterIdSet;
        private long meterId;
        private boolean metersSet;
        private List<OFMeterBand> meters;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.METER_MOD;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFMeterMod.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFMeterModCommand getCommand() {
            return this.command;
        }

        @Override
        public OFMeterMod.Builder setCommand(OFMeterModCommand command) {
            this.command = command;
            this.commandSet = true;
            return this;
        }

        @Override
        public Set<OFMeterFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFMeterMod.Builder setFlags(Set<OFMeterFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public long getMeterId() {
            return this.meterId;
        }

        @Override
        public OFMeterMod.Builder setMeterId(long meterId) {
            this.meterId = meterId;
            this.meterIdSet = true;
            return this;
        }

        @Override
        public List<OFMeterBand> getMeters() {
            return this.meters;
        }

        @Override
        public OFMeterMod.Builder setMeters(List<OFMeterBand> meters) {
            this.meters = meters;
            this.metersSet = true;
            return this;
        }

        @Override
        public List<OFMeterBand> getBands() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property bands not supported in version 1.3");
        }

        @Override
        public OFMeterMod.Builder setBands(List<OFMeterBand> bands) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property bands not supported in version 1.3");
        }

        @Override
        public OFMeterMod build() {
            List<OFMeterBand> meters;
            Set<OFMeterFlags> flags;
            long xid;
            long l = xid = this.xidSet ? this.xid : 0L;
            if (!this.commandSet) {
                throw new IllegalStateException("Property command doesn't have default value -- must be set");
            }
            if (this.command == null) {
                throw new NullPointerException("Property command must not be null");
            }
            Set<OFMeterFlags> set = flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            long meterId = this.meterIdSet ? this.meterId : 0L;
            List<OFMeterBand> list = meters = this.metersSet ? this.meters : DEFAULT_METERS;
            if (meters == null) {
                throw new NullPointerException("Property meters must not be null");
            }
            return new OFMeterModVer13(xid, this.command, flags, meterId, meters);
        }
    }

    static class BuilderWithParent
    implements OFMeterMod.Builder {
        final OFMeterModVer13 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean commandSet;
        private OFMeterModCommand command;
        private boolean flagsSet;
        private Set<OFMeterFlags> flags;
        private boolean meterIdSet;
        private long meterId;
        private boolean metersSet;
        private List<OFMeterBand> meters;

        BuilderWithParent(OFMeterModVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.METER_MOD;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFMeterMod.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFMeterModCommand getCommand() {
            return this.command;
        }

        @Override
        public OFMeterMod.Builder setCommand(OFMeterModCommand command) {
            this.command = command;
            this.commandSet = true;
            return this;
        }

        @Override
        public Set<OFMeterFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFMeterMod.Builder setFlags(Set<OFMeterFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public long getMeterId() {
            return this.meterId;
        }

        @Override
        public OFMeterMod.Builder setMeterId(long meterId) {
            this.meterId = meterId;
            this.meterIdSet = true;
            return this;
        }

        @Override
        public List<OFMeterBand> getMeters() {
            return this.meters;
        }

        @Override
        public OFMeterMod.Builder setMeters(List<OFMeterBand> meters) {
            this.meters = meters;
            this.metersSet = true;
            return this;
        }

        @Override
        public List<OFMeterBand> getBands() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property bands not supported in version 1.3");
        }

        @Override
        public OFMeterMod.Builder setBands(List<OFMeterBand> bands) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property bands not supported in version 1.3");
        }

        @Override
        public OFMeterMod build() {
            List meters;
            Set flags;
            OFMeterModCommand command;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            OFMeterModCommand oFMeterModCommand = command = this.commandSet ? this.command : this.parentMessage.command;
            if (command == null) {
                throw new NullPointerException("Property command must not be null");
            }
            Set set = flags = this.flagsSet ? this.flags : this.parentMessage.flags;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            long meterId = this.meterIdSet ? this.meterId : this.parentMessage.meterId;
            List list = meters = this.metersSet ? this.meters : this.parentMessage.meters;
            if (meters == null) {
                throw new NullPointerException("Property meters must not be null");
            }
            return new OFMeterModVer13(xid, command, flags, meterId, meters);
        }
    }
}

