/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFInstructionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.instructionid.OFInstructionIdWriteActions;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFInstructionIdWriteActionsVer13
implements OFInstructionIdWriteActions {
    private static final Logger logger = LoggerFactory.getLogger(OFInstructionIdWriteActionsVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 4;
    static final OFInstructionIdWriteActionsVer13 DEFAULT = new OFInstructionIdWriteActionsVer13();
    static final OFInstructionIdWriteActionsVer13 INSTANCE = new OFInstructionIdWriteActionsVer13();
    static final Reader READER = new Reader();
    static final OFInstructionIdWriteActionsVer13Funnel FUNNEL = new OFInstructionIdWriteActionsVer13Funnel();
    static final Writer WRITER = new Writer();

    private OFInstructionIdWriteActionsVer13() {
    }

    @Override
    public OFInstructionType getType() {
        return OFInstructionType.WRITE_ACTIONS;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFInstructionIdWriteActions.Builder createBuilder() {
        throw new UnsupportedOperationException("OFInstructionIdWriteActionsVer13 has no mutable properties -- builder unneeded");
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFInstructionIdWriteActionsVer13(");
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFInstructionIdWriteActionsVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFInstructionIdWriteActionsVer13 message) {
            bb.writeShort(3);
            bb.writeShort(4);
        }
    }

    static class OFInstructionIdWriteActionsVer13Funnel
    implements Funnel<OFInstructionIdWriteActionsVer13> {
        private static final long serialVersionUID = 1L;

        OFInstructionIdWriteActionsVer13Funnel() {
        }

        public void funnel(OFInstructionIdWriteActionsVer13 message, PrimitiveSink sink) {
            sink.putShort((short)3);
            sink.putShort((short)4);
        }
    }

    static class Reader
    implements OFMessageReader<OFInstructionIdWriteActions> {
        Reader() {
        }

        @Override
        public OFInstructionIdWriteActions readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 3) {
                throw new OFParseError("Wrong type: Expected=OFInstructionType.WRITE_ACTIONS(3), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 4) {
                throw new OFParseError("Wrong length: Expected=4(4), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - returning shared instance={}", (Object)INSTANCE);
            }
            return INSTANCE;
        }
    }
}

