/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFErrorMsg;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.ver13.OFBadActionErrorMsgVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFBadInstructionErrorMsgVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFBadMatchErrorMsgVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFBadRequestErrorMsgVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFExperimenterErrorMsgVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFFlowModFailedErrorMsgVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFGroupModFailedErrorMsgVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFHelloFailedErrorMsgVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFMeterModFailedErrorMsgVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFPortModFailedErrorMsgVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFQueueOpFailedErrorMsgVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFRoleRequestFailedErrorMsgVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFSwitchConfigFailedErrorMsgVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFTableFeaturesFailedErrorMsgVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFTableModFailedErrorMsgVer13;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;

abstract class OFErrorMsgVer13 {
    static final byte WIRE_VERSION = 4;
    static final int MINIMUM_LENGTH = 10;
    public static final Reader READER = new Reader();

    OFErrorMsgVer13() {
    }

    static class Reader
    implements OFMessageReader<OFErrorMsg> {
        Reader() {
        }

        @Override
        public OFErrorMsg readFrom(ByteBuf bb) throws OFParseError {
            if (bb.readableBytes() < 10) {
                return null;
            }
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 4) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_13(4), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 1) {
                throw new OFParseError("Wrong type: Expected=OFType.ERROR(1), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 10) {
                throw new OFParseError("Wrong length: Expected to be >= 10, was: " + length);
            }
            U32.f(bb.readInt());
            short errType = bb.readShort();
            bb.readerIndex(start);
            switch (errType) {
                case 2: {
                    return OFBadActionErrorMsgVer13.READER.readFrom(bb);
                }
                case 1: {
                    return OFBadRequestErrorMsgVer13.READER.readFrom(bb);
                }
                case 5: {
                    return OFFlowModFailedErrorMsgVer13.READER.readFrom(bb);
                }
                case 0: {
                    return OFHelloFailedErrorMsgVer13.READER.readFrom(bb);
                }
                case 7: {
                    return OFPortModFailedErrorMsgVer13.READER.readFrom(bb);
                }
                case 9: {
                    return OFQueueOpFailedErrorMsgVer13.READER.readFrom(bb);
                }
                case 3: {
                    return OFBadInstructionErrorMsgVer13.READER.readFrom(bb);
                }
                case 4: {
                    return OFBadMatchErrorMsgVer13.READER.readFrom(bb);
                }
                case 6: {
                    return OFGroupModFailedErrorMsgVer13.READER.readFrom(bb);
                }
                case 10: {
                    return OFSwitchConfigFailedErrorMsgVer13.READER.readFrom(bb);
                }
                case 8: {
                    return OFTableModFailedErrorMsgVer13.READER.readFrom(bb);
                }
                case -1: {
                    return OFExperimenterErrorMsgVer13.READER.readFrom(bb);
                }
                case 11: {
                    return OFRoleRequestFailedErrorMsgVer13.READER.readFrom(bb);
                }
                case 12: {
                    return OFMeterModFailedErrorMsgVer13.READER.readFrom(bb);
                }
                case 13: {
                    return OFTableFeaturesFailedErrorMsgVer13.READER.readFrom(bb);
                }
            }
            throw new OFParseError("Unknown value for discriminator errType of class OFErrorMsgVer13: " + errType);
        }
    }
}

