/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvUint32;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvUint32Ver13
implements OFBsnTlvUint32 {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvUint32Ver13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 8;
    private static final long DEFAULT_VALUE = 0L;
    private final long value;
    static final OFBsnTlvUint32Ver13 DEFAULT = new OFBsnTlvUint32Ver13(0L);
    static final Reader READER = new Reader();
    static final OFBsnTlvUint32Ver13Funnel FUNNEL = new OFBsnTlvUint32Ver13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvUint32Ver13(long value) {
        this.value = U32.normalize(value);
    }

    @Override
    public int getType() {
        return 167;
    }

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvUint32.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvUint32Ver13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvUint32Ver13 other = (OFBsnTlvUint32Ver13)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.value ^ this.value >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvUint32Ver13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvUint32Ver13 message) {
            bb.writeShort(167);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.value));
        }
    }

    static class OFBsnTlvUint32Ver13Funnel
    implements Funnel<OFBsnTlvUint32Ver13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvUint32Ver13Funnel() {
        }

        public void funnel(OFBsnTlvUint32Ver13 message, PrimitiveSink sink) {
            sink.putShort((short)167);
            sink.putShort((short)8);
            sink.putLong(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvUint32> {
        Reader() {
        }

        @Override
        public OFBsnTlvUint32 readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 167) {
                throw new OFParseError("Wrong type: Expected=0xa7(0xa7), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long value = U32.f(bb.readInt());
            OFBsnTlvUint32Ver13 bsnTlvUint32Ver13 = new OFBsnTlvUint32Ver13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvUint32Ver13);
            }
            return bsnTlvUint32Ver13;
        }
    }

    static class Builder
    implements OFBsnTlvUint32.Builder {
        private boolean valueSet;
        private long value;

        Builder() {
        }

        @Override
        public int getType() {
            return 167;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvUint32.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvUint32 build() {
            long value = this.valueSet ? this.value : 0L;
            return new OFBsnTlvUint32Ver13(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvUint32.Builder {
        final OFBsnTlvUint32Ver13 parentMessage;
        private boolean valueSet;
        private long value;

        BuilderWithParent(OFBsnTlvUint32Ver13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 167;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvUint32.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvUint32 build() {
            long value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvUint32Ver13(value);
        }
    }
}

