/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnSwlFeature;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvSwlFeature;
import org.projectfloodlight.openflow.protocol.ver13.OFBsnSwlFeatureSerializerVer13;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvSwlFeatureVer13
implements OFBsnTlvSwlFeature {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvSwlFeatureVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 6;
    private final OFBsnSwlFeature value;
    static final Reader READER = new Reader();
    static final OFBsnTlvSwlFeatureVer13Funnel FUNNEL = new OFBsnTlvSwlFeatureVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvSwlFeatureVer13(OFBsnSwlFeature value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvSwlFeatureVer13: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 228;
    }

    @Override
    public OFBsnSwlFeature getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvSwlFeature.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvSwlFeatureVer13(");
        b.append("value=").append((Object)this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvSwlFeatureVer13 other = (OFBsnTlvSwlFeatureVer13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals((Object)other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvSwlFeatureVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvSwlFeatureVer13 message) {
            bb.writeShort(228);
            bb.writeShort(6);
            OFBsnSwlFeatureSerializerVer13.writeTo(bb, message.value);
        }
    }

    static class OFBsnTlvSwlFeatureVer13Funnel
    implements Funnel<OFBsnTlvSwlFeatureVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvSwlFeatureVer13Funnel() {
        }

        public void funnel(OFBsnTlvSwlFeatureVer13 message, PrimitiveSink sink) {
            sink.putShort((short)228);
            sink.putShort((short)6);
            OFBsnSwlFeatureSerializerVer13.putTo(message.value, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvSwlFeature> {
        Reader() {
        }

        @Override
        public OFBsnTlvSwlFeature readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 228) {
                throw new OFParseError("Wrong type: Expected=0xe4(0xe4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 6) {
                throw new OFParseError("Wrong length: Expected=6(6), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFBsnSwlFeature value = OFBsnSwlFeatureSerializerVer13.readFrom(bb);
            OFBsnTlvSwlFeatureVer13 bsnTlvSwlFeatureVer13 = new OFBsnTlvSwlFeatureVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvSwlFeatureVer13);
            }
            return bsnTlvSwlFeatureVer13;
        }
    }

    static class Builder
    implements OFBsnTlvSwlFeature.Builder {
        private boolean valueSet;
        private OFBsnSwlFeature value;

        Builder() {
        }

        @Override
        public int getType() {
            return 228;
        }

        @Override
        public OFBsnSwlFeature getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvSwlFeature.Builder setValue(OFBsnSwlFeature value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvSwlFeature build() {
            if (!this.valueSet) {
                throw new IllegalStateException("Property value doesn't have default value -- must be set");
            }
            if (this.value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvSwlFeatureVer13(this.value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvSwlFeature.Builder {
        final OFBsnTlvSwlFeatureVer13 parentMessage;
        private boolean valueSet;
        private OFBsnSwlFeature value;

        BuilderWithParent(OFBsnTlvSwlFeatureVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 228;
        }

        @Override
        public OFBsnSwlFeature getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvSwlFeature.Builder setValue(OFBsnSwlFeature value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvSwlFeature build() {
            OFBsnSwlFeature value;
            OFBsnSwlFeature oFBsnSwlFeature = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvSwlFeatureVer13(value);
        }
    }
}

