/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnCml;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvSrcMacCml;
import org.projectfloodlight.openflow.protocol.ver13.OFBsnCmlSerializerVer13;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvSrcMacCmlVer13
implements OFBsnTlvSrcMacCml {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvSrcMacCmlVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 6;
    private final OFBsnCml value;
    static final Reader READER = new Reader();
    static final OFBsnTlvSrcMacCmlVer13Funnel FUNNEL = new OFBsnTlvSrcMacCmlVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvSrcMacCmlVer13(OFBsnCml value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvSrcMacCmlVer13: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 191;
    }

    @Override
    public OFBsnCml getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvSrcMacCml.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvSrcMacCmlVer13(");
        b.append("value=").append((Object)this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvSrcMacCmlVer13 other = (OFBsnTlvSrcMacCmlVer13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals((Object)other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvSrcMacCmlVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvSrcMacCmlVer13 message) {
            bb.writeShort(191);
            bb.writeShort(6);
            OFBsnCmlSerializerVer13.writeTo(bb, message.value);
        }
    }

    static class OFBsnTlvSrcMacCmlVer13Funnel
    implements Funnel<OFBsnTlvSrcMacCmlVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvSrcMacCmlVer13Funnel() {
        }

        public void funnel(OFBsnTlvSrcMacCmlVer13 message, PrimitiveSink sink) {
            sink.putShort((short)191);
            sink.putShort((short)6);
            OFBsnCmlSerializerVer13.putTo(message.value, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvSrcMacCml> {
        Reader() {
        }

        @Override
        public OFBsnTlvSrcMacCml readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 191) {
                throw new OFParseError("Wrong type: Expected=0xbf(0xbf), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 6) {
                throw new OFParseError("Wrong length: Expected=6(6), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFBsnCml value = OFBsnCmlSerializerVer13.readFrom(bb);
            OFBsnTlvSrcMacCmlVer13 bsnTlvSrcMacCmlVer13 = new OFBsnTlvSrcMacCmlVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvSrcMacCmlVer13);
            }
            return bsnTlvSrcMacCmlVer13;
        }
    }

    static class Builder
    implements OFBsnTlvSrcMacCml.Builder {
        private boolean valueSet;
        private OFBsnCml value;

        Builder() {
        }

        @Override
        public int getType() {
            return 191;
        }

        @Override
        public OFBsnCml getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvSrcMacCml.Builder setValue(OFBsnCml value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvSrcMacCml build() {
            if (!this.valueSet) {
                throw new IllegalStateException("Property value doesn't have default value -- must be set");
            }
            if (this.value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvSrcMacCmlVer13(this.value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvSrcMacCml.Builder {
        final OFBsnTlvSrcMacCmlVer13 parentMessage;
        private boolean valueSet;
        private OFBsnCml value;

        BuilderWithParent(OFBsnTlvSrcMacCmlVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 191;
        }

        @Override
        public OFBsnCml getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvSrcMacCml.Builder setValue(OFBsnCml value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvSrcMacCml build() {
            OFBsnCml value;
            OFBsnCml oFBsnCml = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvSrcMacCmlVer13(value);
        }
    }
}

