/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnPacketField;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvPacketField;
import org.projectfloodlight.openflow.protocol.ver13.OFBsnPacketFieldSerializerVer13;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvPacketFieldVer13
implements OFBsnTlvPacketField {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvPacketFieldVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 6;
    private final OFBsnPacketField value;
    static final Reader READER = new Reader();
    static final OFBsnTlvPacketFieldVer13Funnel FUNNEL = new OFBsnTlvPacketFieldVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvPacketFieldVer13(OFBsnPacketField value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvPacketFieldVer13: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 222;
    }

    @Override
    public OFBsnPacketField getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvPacketField.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvPacketFieldVer13(");
        b.append("value=").append((Object)this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvPacketFieldVer13 other = (OFBsnTlvPacketFieldVer13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals((Object)other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvPacketFieldVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvPacketFieldVer13 message) {
            bb.writeShort(222);
            bb.writeShort(6);
            OFBsnPacketFieldSerializerVer13.writeTo(bb, message.value);
        }
    }

    static class OFBsnTlvPacketFieldVer13Funnel
    implements Funnel<OFBsnTlvPacketFieldVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvPacketFieldVer13Funnel() {
        }

        public void funnel(OFBsnTlvPacketFieldVer13 message, PrimitiveSink sink) {
            sink.putShort((short)222);
            sink.putShort((short)6);
            OFBsnPacketFieldSerializerVer13.putTo(message.value, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvPacketField> {
        Reader() {
        }

        @Override
        public OFBsnTlvPacketField readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 222) {
                throw new OFParseError("Wrong type: Expected=0xde(0xde), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 6) {
                throw new OFParseError("Wrong length: Expected=6(6), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFBsnPacketField value = OFBsnPacketFieldSerializerVer13.readFrom(bb);
            OFBsnTlvPacketFieldVer13 bsnTlvPacketFieldVer13 = new OFBsnTlvPacketFieldVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvPacketFieldVer13);
            }
            return bsnTlvPacketFieldVer13;
        }
    }

    static class Builder
    implements OFBsnTlvPacketField.Builder {
        private boolean valueSet;
        private OFBsnPacketField value;

        Builder() {
        }

        @Override
        public int getType() {
            return 222;
        }

        @Override
        public OFBsnPacketField getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvPacketField.Builder setValue(OFBsnPacketField value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvPacketField build() {
            if (!this.valueSet) {
                throw new IllegalStateException("Property value doesn't have default value -- must be set");
            }
            if (this.value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvPacketFieldVer13(this.value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvPacketField.Builder {
        final OFBsnTlvPacketFieldVer13 parentMessage;
        private boolean valueSet;
        private OFBsnPacketField value;

        BuilderWithParent(OFBsnTlvPacketFieldVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 222;
        }

        @Override
        public OFBsnPacketField getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvPacketField.Builder setValue(OFBsnPacketField value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvPacketField build() {
            OFBsnPacketField value;
            OFBsnPacketField oFBsnPacketField = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvPacketFieldVer13(value);
        }
    }
}

