/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvMaxCount;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvMaxCountVer13
implements OFBsnTlvMaxCount {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvMaxCountVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 8;
    private static final long DEFAULT_VALUE = 0L;
    private final long value;
    static final OFBsnTlvMaxCountVer13 DEFAULT = new OFBsnTlvMaxCountVer13(0L);
    static final Reader READER = new Reader();
    static final OFBsnTlvMaxCountVer13Funnel FUNNEL = new OFBsnTlvMaxCountVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvMaxCountVer13(long value) {
        this.value = U32.normalize(value);
    }

    @Override
    public int getType() {
        return 214;
    }

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvMaxCount.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvMaxCountVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvMaxCountVer13 other = (OFBsnTlvMaxCountVer13)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.value ^ this.value >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvMaxCountVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvMaxCountVer13 message) {
            bb.writeShort(214);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.value));
        }
    }

    static class OFBsnTlvMaxCountVer13Funnel
    implements Funnel<OFBsnTlvMaxCountVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvMaxCountVer13Funnel() {
        }

        public void funnel(OFBsnTlvMaxCountVer13 message, PrimitiveSink sink) {
            sink.putShort((short)214);
            sink.putShort((short)8);
            sink.putLong(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvMaxCount> {
        Reader() {
        }

        @Override
        public OFBsnTlvMaxCount readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 214) {
                throw new OFParseError("Wrong type: Expected=0xd6(0xd6), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long value = U32.f(bb.readInt());
            OFBsnTlvMaxCountVer13 bsnTlvMaxCountVer13 = new OFBsnTlvMaxCountVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvMaxCountVer13);
            }
            return bsnTlvMaxCountVer13;
        }
    }

    static class Builder
    implements OFBsnTlvMaxCount.Builder {
        private boolean valueSet;
        private long value;

        Builder() {
        }

        @Override
        public int getType() {
            return 214;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvMaxCount.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvMaxCount build() {
            long value = this.valueSet ? this.value : 0L;
            return new OFBsnTlvMaxCountVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvMaxCount.Builder {
        final OFBsnTlvMaxCountVer13 parentMessage;
        private boolean valueSet;
        private long value;

        BuilderWithParent(OFBsnTlvMaxCountVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 214;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvMaxCount.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvMaxCount build() {
            long value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvMaxCountVer13(value);
        }
    }
}

