/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvIpv4Src;
import org.projectfloodlight.openflow.types.IPv4Address;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvIpv4SrcVer13
implements OFBsnTlvIpv4Src {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvIpv4SrcVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 8;
    private static final IPv4Address DEFAULT_VALUE = IPv4Address.NONE;
    private final IPv4Address value;
    static final OFBsnTlvIpv4SrcVer13 DEFAULT = new OFBsnTlvIpv4SrcVer13(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFBsnTlvIpv4SrcVer13Funnel FUNNEL = new OFBsnTlvIpv4SrcVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvIpv4SrcVer13(IPv4Address value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvIpv4SrcVer13: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 34;
    }

    @Override
    public IPv4Address getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvIpv4Src.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvIpv4SrcVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvIpv4SrcVer13 other = (OFBsnTlvIpv4SrcVer13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvIpv4SrcVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvIpv4SrcVer13 message) {
            bb.writeShort(34);
            bb.writeShort(8);
            message.value.write4Bytes(bb);
        }
    }

    static class OFBsnTlvIpv4SrcVer13Funnel
    implements Funnel<OFBsnTlvIpv4SrcVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvIpv4SrcVer13Funnel() {
        }

        public void funnel(OFBsnTlvIpv4SrcVer13 message, PrimitiveSink sink) {
            sink.putShort((short)34);
            sink.putShort((short)8);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvIpv4Src> {
        Reader() {
        }

        @Override
        public OFBsnTlvIpv4Src readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 34) {
                throw new OFParseError("Wrong type: Expected=0x22(0x22), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            IPv4Address value = IPv4Address.read4Bytes(bb);
            OFBsnTlvIpv4SrcVer13 bsnTlvIpv4SrcVer13 = new OFBsnTlvIpv4SrcVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvIpv4SrcVer13);
            }
            return bsnTlvIpv4SrcVer13;
        }
    }

    static class Builder
    implements OFBsnTlvIpv4Src.Builder {
        private boolean valueSet;
        private IPv4Address value;

        Builder() {
        }

        @Override
        public int getType() {
            return 34;
        }

        @Override
        public IPv4Address getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvIpv4Src.Builder setValue(IPv4Address value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvIpv4Src build() {
            IPv4Address value;
            IPv4Address iPv4Address = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvIpv4SrcVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvIpv4Src.Builder {
        final OFBsnTlvIpv4SrcVer13 parentMessage;
        private boolean valueSet;
        private IPv4Address value;

        BuilderWithParent(OFBsnTlvIpv4SrcVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 34;
        }

        @Override
        public IPv4Address getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvIpv4Src.Builder setValue(IPv4Address value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvIpv4Src build() {
            IPv4Address value;
            IPv4Address iPv4Address = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvIpv4SrcVer13(value);
        }
    }
}

