/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnIpFragmentation;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvIpFragmentation;
import org.projectfloodlight.openflow.protocol.ver13.OFBsnIpFragmentationSerializerVer13;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvIpFragmentationVer13
implements OFBsnTlvIpFragmentation {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvIpFragmentationVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 5;
    private final OFBsnIpFragmentation value;
    static final Reader READER = new Reader();
    static final OFBsnTlvIpFragmentationVer13Funnel FUNNEL = new OFBsnTlvIpFragmentationVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvIpFragmentationVer13(OFBsnIpFragmentation value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvIpFragmentationVer13: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 201;
    }

    @Override
    public OFBsnIpFragmentation getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvIpFragmentation.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvIpFragmentationVer13(");
        b.append("value=").append((Object)this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvIpFragmentationVer13 other = (OFBsnTlvIpFragmentationVer13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals((Object)other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvIpFragmentationVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvIpFragmentationVer13 message) {
            bb.writeShort(201);
            bb.writeShort(5);
            OFBsnIpFragmentationSerializerVer13.writeTo(bb, message.value);
        }
    }

    static class OFBsnTlvIpFragmentationVer13Funnel
    implements Funnel<OFBsnTlvIpFragmentationVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvIpFragmentationVer13Funnel() {
        }

        public void funnel(OFBsnTlvIpFragmentationVer13 message, PrimitiveSink sink) {
            sink.putShort((short)201);
            sink.putShort((short)5);
            OFBsnIpFragmentationSerializerVer13.putTo(message.value, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvIpFragmentation> {
        Reader() {
        }

        @Override
        public OFBsnTlvIpFragmentation readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 201) {
                throw new OFParseError("Wrong type: Expected=0xc9(0xc9), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 5) {
                throw new OFParseError("Wrong length: Expected=5(5), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFBsnIpFragmentation value = OFBsnIpFragmentationSerializerVer13.readFrom(bb);
            OFBsnTlvIpFragmentationVer13 bsnTlvIpFragmentationVer13 = new OFBsnTlvIpFragmentationVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvIpFragmentationVer13);
            }
            return bsnTlvIpFragmentationVer13;
        }
    }

    static class Builder
    implements OFBsnTlvIpFragmentation.Builder {
        private boolean valueSet;
        private OFBsnIpFragmentation value;

        Builder() {
        }

        @Override
        public int getType() {
            return 201;
        }

        @Override
        public OFBsnIpFragmentation getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvIpFragmentation.Builder setValue(OFBsnIpFragmentation value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvIpFragmentation build() {
            if (!this.valueSet) {
                throw new IllegalStateException("Property value doesn't have default value -- must be set");
            }
            if (this.value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvIpFragmentationVer13(this.value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvIpFragmentation.Builder {
        final OFBsnTlvIpFragmentationVer13 parentMessage;
        private boolean valueSet;
        private OFBsnIpFragmentation value;

        BuilderWithParent(OFBsnTlvIpFragmentationVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 201;
        }

        @Override
        public OFBsnIpFragmentation getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvIpFragmentation.Builder setValue(OFBsnIpFragmentation value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvIpFragmentation build() {
            OFBsnIpFragmentation value;
            OFBsnIpFragmentation oFBsnIpFragmentation = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvIpFragmentationVer13(value);
        }
    }
}

