/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvFlowIdentifier;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvFlowIdentifierVer13
implements OFBsnTlvFlowIdentifier {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvFlowIdentifierVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 8;
    private static final long DEFAULT_VALUE = 0L;
    private final long value;
    static final OFBsnTlvFlowIdentifierVer13 DEFAULT = new OFBsnTlvFlowIdentifierVer13(0L);
    static final Reader READER = new Reader();
    static final OFBsnTlvFlowIdentifierVer13Funnel FUNNEL = new OFBsnTlvFlowIdentifierVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvFlowIdentifierVer13(long value) {
        this.value = U32.normalize(value);
    }

    @Override
    public int getType() {
        return 183;
    }

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvFlowIdentifier.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvFlowIdentifierVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvFlowIdentifierVer13 other = (OFBsnTlvFlowIdentifierVer13)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.value ^ this.value >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvFlowIdentifierVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvFlowIdentifierVer13 message) {
            bb.writeShort(183);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.value));
        }
    }

    static class OFBsnTlvFlowIdentifierVer13Funnel
    implements Funnel<OFBsnTlvFlowIdentifierVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvFlowIdentifierVer13Funnel() {
        }

        public void funnel(OFBsnTlvFlowIdentifierVer13 message, PrimitiveSink sink) {
            sink.putShort((short)183);
            sink.putShort((short)8);
            sink.putLong(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvFlowIdentifier> {
        Reader() {
        }

        @Override
        public OFBsnTlvFlowIdentifier readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 183) {
                throw new OFParseError("Wrong type: Expected=0xb7(0xb7), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long value = U32.f(bb.readInt());
            OFBsnTlvFlowIdentifierVer13 bsnTlvFlowIdentifierVer13 = new OFBsnTlvFlowIdentifierVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvFlowIdentifierVer13);
            }
            return bsnTlvFlowIdentifierVer13;
        }
    }

    static class Builder
    implements OFBsnTlvFlowIdentifier.Builder {
        private boolean valueSet;
        private long value;

        Builder() {
        }

        @Override
        public int getType() {
            return 183;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvFlowIdentifier.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvFlowIdentifier build() {
            long value = this.valueSet ? this.value : 0L;
            return new OFBsnTlvFlowIdentifierVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvFlowIdentifier.Builder {
        final OFBsnTlvFlowIdentifierVer13 parentMessage;
        private boolean valueSet;
        private long value;

        BuilderWithParent(OFBsnTlvFlowIdentifierVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 183;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvFlowIdentifier.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvFlowIdentifier build() {
            long value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvFlowIdentifierVer13(value);
        }
    }
}

