/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnFlowClassifier;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvFlowClassifier;
import org.projectfloodlight.openflow.protocol.ver13.OFBsnFlowClassifierSerializerVer13;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvFlowClassifierVer13
implements OFBsnTlvFlowClassifier {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvFlowClassifierVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 6;
    private final OFBsnFlowClassifier value;
    static final Reader READER = new Reader();
    static final OFBsnTlvFlowClassifierVer13Funnel FUNNEL = new OFBsnTlvFlowClassifierVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvFlowClassifierVer13(OFBsnFlowClassifier value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvFlowClassifierVer13: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 184;
    }

    @Override
    public OFBsnFlowClassifier getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvFlowClassifier.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvFlowClassifierVer13(");
        b.append("value=").append((Object)this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvFlowClassifierVer13 other = (OFBsnTlvFlowClassifierVer13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals((Object)other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvFlowClassifierVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvFlowClassifierVer13 message) {
            bb.writeShort(184);
            bb.writeShort(6);
            OFBsnFlowClassifierSerializerVer13.writeTo(bb, message.value);
        }
    }

    static class OFBsnTlvFlowClassifierVer13Funnel
    implements Funnel<OFBsnTlvFlowClassifierVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvFlowClassifierVer13Funnel() {
        }

        public void funnel(OFBsnTlvFlowClassifierVer13 message, PrimitiveSink sink) {
            sink.putShort((short)184);
            sink.putShort((short)6);
            OFBsnFlowClassifierSerializerVer13.putTo(message.value, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvFlowClassifier> {
        Reader() {
        }

        @Override
        public OFBsnTlvFlowClassifier readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 184) {
                throw new OFParseError("Wrong type: Expected=0xb8(0xb8), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 6) {
                throw new OFParseError("Wrong length: Expected=6(6), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFBsnFlowClassifier value = OFBsnFlowClassifierSerializerVer13.readFrom(bb);
            OFBsnTlvFlowClassifierVer13 bsnTlvFlowClassifierVer13 = new OFBsnTlvFlowClassifierVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvFlowClassifierVer13);
            }
            return bsnTlvFlowClassifierVer13;
        }
    }

    static class Builder
    implements OFBsnTlvFlowClassifier.Builder {
        private boolean valueSet;
        private OFBsnFlowClassifier value;

        Builder() {
        }

        @Override
        public int getType() {
            return 184;
        }

        @Override
        public OFBsnFlowClassifier getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvFlowClassifier.Builder setValue(OFBsnFlowClassifier value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvFlowClassifier build() {
            if (!this.valueSet) {
                throw new IllegalStateException("Property value doesn't have default value -- must be set");
            }
            if (this.value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvFlowClassifierVer13(this.value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvFlowClassifier.Builder {
        final OFBsnTlvFlowClassifierVer13 parentMessage;
        private boolean valueSet;
        private OFBsnFlowClassifier value;

        BuilderWithParent(OFBsnTlvFlowClassifierVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 184;
        }

        @Override
        public OFBsnFlowClassifier getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvFlowClassifier.Builder setValue(OFBsnFlowClassifier value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvFlowClassifier build() {
            OFBsnFlowClassifier value;
            OFBsnFlowClassifier oFBsnFlowClassifier = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvFlowClassifierVer13(value);
        }
    }
}

