/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnAnchor;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvAnchor;
import org.projectfloodlight.openflow.protocol.ver13.OFBsnAnchorSerializerVer13;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvAnchorVer13
implements OFBsnTlvAnchor {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvAnchorVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 6;
    private final OFBsnAnchor value;
    static final Reader READER = new Reader();
    static final OFBsnTlvAnchorVer13Funnel FUNNEL = new OFBsnTlvAnchorVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvAnchorVer13(OFBsnAnchor value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvAnchorVer13: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 81;
    }

    @Override
    public OFBsnAnchor getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvAnchor.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvAnchorVer13(");
        b.append("value=").append((Object)this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvAnchorVer13 other = (OFBsnTlvAnchorVer13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals((Object)other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvAnchorVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvAnchorVer13 message) {
            bb.writeShort(81);
            bb.writeShort(6);
            OFBsnAnchorSerializerVer13.writeTo(bb, message.value);
        }
    }

    static class OFBsnTlvAnchorVer13Funnel
    implements Funnel<OFBsnTlvAnchorVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvAnchorVer13Funnel() {
        }

        public void funnel(OFBsnTlvAnchorVer13 message, PrimitiveSink sink) {
            sink.putShort((short)81);
            sink.putShort((short)6);
            OFBsnAnchorSerializerVer13.putTo(message.value, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvAnchor> {
        Reader() {
        }

        @Override
        public OFBsnTlvAnchor readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 81) {
                throw new OFParseError("Wrong type: Expected=0x51(0x51), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 6) {
                throw new OFParseError("Wrong length: Expected=6(6), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFBsnAnchor value = OFBsnAnchorSerializerVer13.readFrom(bb);
            OFBsnTlvAnchorVer13 bsnTlvAnchorVer13 = new OFBsnTlvAnchorVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvAnchorVer13);
            }
            return bsnTlvAnchorVer13;
        }
    }

    static class Builder
    implements OFBsnTlvAnchor.Builder {
        private boolean valueSet;
        private OFBsnAnchor value;

        Builder() {
        }

        @Override
        public int getType() {
            return 81;
        }

        @Override
        public OFBsnAnchor getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvAnchor.Builder setValue(OFBsnAnchor value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvAnchor build() {
            if (!this.valueSet) {
                throw new IllegalStateException("Property value doesn't have default value -- must be set");
            }
            if (this.value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvAnchorVer13(this.value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvAnchor.Builder {
        final OFBsnTlvAnchorVer13 parentMessage;
        private boolean valueSet;
        private OFBsnAnchor value;

        BuilderWithParent(OFBsnTlvAnchorVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 81;
        }

        @Override
        public OFBsnAnchor getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvAnchor.Builder setValue(OFBsnAnchor value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvAnchor build() {
            OFBsnAnchor value;
            OFBsnAnchor oFBsnAnchor = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvAnchorVer13(value);
        }
    }
}

